/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteUnsignedApplet;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionEntry;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionStorage;
import net.sourceforge.jnlp.util.lockingfile.LockingReaderWriter;
import net.sourceforge.jnlp.util.lockingfile.StorageIoException;

public class UnsignedAppletActionStorageImpl
extends LockingReaderWriter
implements UnsignedAppletActionStorage {
    protected List<UnsignedAppletActionEntry> items;

    public UnsignedAppletActionStorageImpl(String string) {
        this(new File(string));
    }

    public UnsignedAppletActionStorageImpl(File file) {
        super(file);
    }

    @Override
    public void writeContents() throws IOException {
        super.writeContents();
    }

    @Override
    public synchronized void writeContentsLocked() throws IOException {
        super.writeContentsLocked();
    }

    @Override
    protected void readContents() throws IOException {
        if (this.items == null) {
            this.items = new ArrayList<UnsignedAppletActionEntry>();
        } else {
            this.items.clear();
        }
        super.readContents();
    }

    @Override
    protected void readLine(String string) {
        if (string.trim().length() != 0) {
            this.items.add(UnsignedAppletActionEntry.createFromString(string));
        }
    }

    @Override
    public void writeContent(BufferedWriter bufferedWriter) throws IOException {
        for (UnsignedAppletActionEntry unsignedAppletActionEntry : this.items) {
            unsignedAppletActionEntry.write(bufferedWriter);
            bufferedWriter.newLine();
        }
    }

    @Override
    public void add(final UnsignedAppletActionEntry unsignedAppletActionEntry) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    UnsignedAppletActionStorageImpl.this.readContents();
                    UnsignedAppletActionStorageImpl.this.items.add(unsignedAppletActionEntry);
                    UnsignedAppletActionStorageImpl.this.writeContents();
                }
                catch (IOException iOException) {
                    throw new StorageIoException(iOException);
                }
            }
        });
    }

    @Override
    public void update(final UnsignedAppletActionEntry unsignedAppletActionEntry) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    if (UnsignedAppletActionStorageImpl.this.items == null) {
                        throw new StorageIoException("Storage is not initialised, can not update");
                    }
                    if (!UnsignedAppletActionStorageImpl.this.items.contains(unsignedAppletActionEntry)) {
                        throw new StorageIoException("Storage does not contain item you are updating. can not update");
                    }
                    UnsignedAppletActionStorageImpl.this.writeContents();
                }
                catch (IOException iOException) {
                    throw new StorageIoException(iOException);
                }
            }
        });
    }

    @Override
    public UnsignedAppletActionEntry getMatchingItem(String string, String string2, List<String> list) {
        List<UnsignedAppletActionEntry> list2 = this.getMatchingItems(string, string2, list);
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        for (UnsignedAppletActionEntry unsignedAppletActionEntry : list2) {
            if (unsignedAppletActionEntry.getUnsignedAppletAction() != ExecuteUnsignedApplet.ALWAYS && unsignedAppletActionEntry.getUnsignedAppletAction() != ExecuteUnsignedApplet.NEVER) continue;
            return unsignedAppletActionEntry;
        }
        return list2.get(0);
    }

    public List<UnsignedAppletActionEntry> getMatchingItems(String string, String string2, List<String> list) {
        ArrayList<UnsignedAppletActionEntry> arrayList = new ArrayList<UnsignedAppletActionEntry>();
        this.lock();
        try {
            this.readContents();
            if (this.items == null) {
                ArrayList<UnsignedAppletActionEntry> arrayList2 = arrayList;
                return arrayList2;
            }
            for (UnsignedAppletActionEntry unsignedAppletActionEntry : this.items) {
                if (!this.isMatching(unsignedAppletActionEntry, string, string2, list)) continue;
                arrayList.add(unsignedAppletActionEntry);
            }
        }
        catch (IOException iOException) {
            throw new StorageIoException(iOException);
        }
        finally {
            this.unlock();
        }
        return arrayList;
    }

    private boolean isMatching(UnsignedAppletActionEntry unsignedAppletActionEntry, String string, String string2, List<String> list) {
        boolean bl = true;
        if (string != null && !string.trim().isEmpty()) {
            boolean bl2 = bl = bl && string.matches(unsignedAppletActionEntry.getDocumentBase().getRegEx());
        }
        if (string2 != null && !string2.trim().isEmpty()) {
            boolean bl3 = bl = bl && string2.matches(unsignedAppletActionEntry.getCodeBase().getRegEx());
        }
        if (list != null) {
            List<String> list2 = unsignedAppletActionEntry.getArchives();
            if (list2 == null || list2.isEmpty()) {
                return bl;
            }
            bl = bl && this.compareArchives(list, list2);
        }
        return bl;
    }

    public String toString() {
        return this.getBackingFile() + " " + super.toString();
    }

    private boolean compareArchives(List<String> list, List<String> list2) {
        if (list == null && list2 != null) {
            return false;
        }
        if (list != null && list2 == null) {
            return false;
        }
        if (list == null && list2 == null) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        Collections.sort(list);
        Collections.sort(list2);
        for (int i = 0; i < list2.size(); ++i) {
            String string;
            String string2 = list2.get(i);
            if (string2 == (string = list.get(i))) continue;
            if (string2 == null || string == null) {
                return false;
            }
            if (string2.trim().equals(string.trim())) continue;
            return false;
        }
        return true;
    }

    @Override
    public UnsignedAppletActionEntry getMatchingItemByDocumentBase(String string) {
        return this.getMatchingItem(string, null, null);
    }

    @Override
    public UnsignedAppletActionEntry getMatchingItemByCodeBase(String string) {
        return this.getMatchingItem(null, string, null);
    }

    @Override
    public UnsignedAppletActionEntry getMatchingItemByBases(String string, String string2) {
        return this.getMatchingItem(string, string2, null);
    }
}

