/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteUnsignedApplet;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExtendedAppletSecurityHelp;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletTrustConfirmation;
import net.sourceforge.jnlp.util.ScreenFinder;
import sun.misc.Launcher;

public class UnsignedAppletTrustWarningPanel
extends JPanel {
    private final int PANE_WIDTH = 500;
    private final int TOP_PANEL_HEIGHT = 60;
    private final int INFO_PANEL_HEIGHT = 140;
    private final int INFO_PANEL_HINT_HEIGHT = 25;
    private final int QUESTION_PANEL_HEIGHT = 35;
    private JButton allowButton;
    private JButton rejectButton;
    private JButton helpButton;
    private JCheckBox permanencyCheckBox;
    private JRadioButton applyToAppletButton;
    private JRadioButton applyToCodeBaseButton;
    private PluginBridge file;
    private ActionChoiceListener actionChoiceListener;

    public UnsignedAppletTrustWarningPanel(PluginBridge pluginBridge, ActionChoiceListener actionChoiceListener) {
        this.file = pluginBridge;
        this.actionChoiceListener = actionChoiceListener;
        this.addComponents();
    }

    public JButton getAllowButton() {
        return this.allowButton;
    }

    public JButton getRejectButton() {
        return this.rejectButton;
    }

    private String htmlWrap(String string) {
        return "<html>" + string + "</html>";
    }

    private ImageIcon infoImage() {
        ClassLoader classLoader = new Launcher().getClassLoader();
        return new ImageIcon(classLoader.getResource("net/sourceforge/jnlp/resources/info-small.png"));
    }

    private void setupTopPanel() {
        String string = Translator.R("SUnsignedSummary");
        JLabel jLabel = new JLabel(this.htmlWrap(string), this.infoImage(), 2);
        jLabel.setFont(new Font(jLabel.getFont().toString(), 1, 12));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.add((Component)jLabel, "Center");
        jPanel.setPreferredSize(new Dimension(500, 60));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(jPanel);
    }

    private void setupInfoPanel() {
        String string = Translator.R("SUnsignedDetail", this.file.getCodeBase(), this.file.getSourceLocation());
        ExecuteUnsignedApplet executeUnsignedApplet = UnsignedAppletTrustConfirmation.getStoredAction(this.file);
        int n = 140;
        if (executeUnsignedApplet == ExecuteUnsignedApplet.YES) {
            string = string + "<br>" + Translator.R("SUnsignedAllowedBefore");
            n += 25;
        } else if (executeUnsignedApplet == ExecuteUnsignedApplet.NO) {
            string = string + "<br>" + Translator.R("SUnsignedRejectedBefore");
            n += 25;
        }
        JLabel jLabel = new JLabel(this.htmlWrap(string));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "Center");
        jPanel.setPreferredSize(new Dimension(500, n));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(jPanel);
    }

    private void setupQuestionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(this.htmlWrap(Translator.R("SUnsignedQuestion"))), "East");
        jPanel.setPreferredSize(new Dimension(500, 35));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add(jPanel);
    }

    private JPanel createMatchOptionsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.applyToAppletButton = new JRadioButton(Translator.R("SRememberAppletOnly"));
        this.applyToAppletButton.setSelected(true);
        this.applyToAppletButton.setEnabled(false);
        this.applyToCodeBaseButton = new JRadioButton(this.htmlWrap(Translator.R("SRememberCodebase", this.file.getCodeBase())));
        this.applyToCodeBaseButton.setEnabled(false);
        buttonGroup.add(this.applyToAppletButton);
        buttonGroup.add(this.applyToCodeBaseButton);
        jPanel.add(this.applyToAppletButton);
        jPanel.add(this.applyToCodeBaseButton);
        return jPanel;
    }

    private JPanel createCheckBoxPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.permanencyCheckBox = new JCheckBox(this.htmlWrap(Translator.R("SRememberOption")));
        this.permanencyCheckBox.addActionListener(this.permanencyListener());
        jPanel.add(this.permanencyCheckBox);
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.allowButton = new JButton(Translator.R("ButProceed"));
        this.rejectButton = new JButton(Translator.R("ButCancel"));
        this.helpButton = new JButton(Translator.R("APPEXTSECguiPanelHelpButton"));
        this.allowButton.addActionListener(this.chosenActionSetter(true));
        this.rejectButton.addActionListener(this.chosenActionSetter(false));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedAppletSecurityHelp extendedAppletSecurityHelp = new ExtendedAppletSecurityHelp(null, false, "dialogue");
                ScreenFinder.centerWindowsToCurrentScreen(extendedAppletSecurityHelp);
                extendedAppletSecurityHelp.setVisible(true);
            }
        });
        jPanel.add(this.allowButton);
        jPanel.add(this.rejectButton);
        jPanel.add(this.helpButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        return jPanel;
    }

    private void setupButtonAndCheckBoxPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(this.createCheckBoxPanel());
        jPanel2.add(this.createMatchOptionsPanel());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)this.createButtonPanel(), "East");
        this.add(jPanel);
    }

    private void addComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setupTopPanel();
        this.setupInfoPanel();
        this.setupQuestionsPanel();
        this.setupButtonAndCheckBoxPanel();
    }

    private ActionListener permanencyListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnsignedAppletTrustWarningPanel.this.applyToAppletButton.setEnabled(UnsignedAppletTrustWarningPanel.this.permanencyCheckBox.isSelected());
                UnsignedAppletTrustWarningPanel.this.applyToCodeBaseButton.setEnabled(UnsignedAppletTrustWarningPanel.this.permanencyCheckBox.isSelected());
            }
        };
    }

    private ActionListener chosenActionSetter(final boolean bl) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExecuteUnsignedApplet executeUnsignedApplet = bl ? (UnsignedAppletTrustWarningPanel.this.permanencyCheckBox.isSelected() ? ExecuteUnsignedApplet.ALWAYS : ExecuteUnsignedApplet.YES) : (UnsignedAppletTrustWarningPanel.this.permanencyCheckBox.isSelected() ? ExecuteUnsignedApplet.NEVER : ExecuteUnsignedApplet.NO);
                boolean bl2 = UnsignedAppletTrustWarningPanel.this.applyToCodeBaseButton.isSelected();
                UnsignedAppletTrustWarningPanel.this.actionChoiceListener.actionChosen(new UnsignedWarningAction(executeUnsignedApplet, bl2));
            }
        };
    }

    public static interface ActionChoiceListener {
        public void actionChosen(UnsignedWarningAction var1);
    }

    public static class UnsignedWarningAction {
        private ExecuteUnsignedApplet action;
        private boolean applyToCodeBase;

        public UnsignedWarningAction(ExecuteUnsignedApplet executeUnsignedApplet, boolean bl) {
            this.action = executeUnsignedApplet;
            this.applyToCodeBase = bl;
        }

        public ExecuteUnsignedApplet getAction() {
            return this.action;
        }

        public boolean rememberForCodeBase() {
            return this.applyToCodeBase;
        }
    }
}

