/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.security.cert.CertPath;
import java.util.Map;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.AppVerifier;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.tools.CertInformation;
import net.sourceforge.jnlp.tools.JarCertVerifier;

public class JNLPAppVerifier
implements AppVerifier {
    @Override
    public boolean hasAlreadyTrustedPublisher(Map<CertPath, CertInformation> map, Map<String, Integer> map2) {
        int n = JarCertVerifier.getTotalJarEntries(map2);
        for (CertInformation certInformation : map.values()) {
            Map<String, Integer> map3 = certInformation.getSignedJars();
            if (JarCertVerifier.getTotalJarEntries(map3) != n || !certInformation.isPublisherAlreadyTrusted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRootInCacerts(Map<CertPath, CertInformation> map, Map<String, Integer> map2) {
        int n = JarCertVerifier.getTotalJarEntries(map2);
        for (CertInformation certInformation : map.values()) {
            Map<String, Integer> map3 = certInformation.getSignedJars();
            if (JarCertVerifier.getTotalJarEntries(map3) != n || !certInformation.isRootInCacerts()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFullySigned(Map<CertPath, CertInformation> map, Map<String, Integer> map2) {
        int n = JarCertVerifier.getTotalJarEntries(map2);
        for (CertPath certPath : map.keySet()) {
            if (!this.hasCompletelySignedApp(map.get(certPath), n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkTrustWithUser(JarCertVerifier jarCertVerifier, JNLPFile jNLPFile) throws LaunchException {
        int n = JarCertVerifier.getTotalJarEntries(jarCertVerifier.getJarSignableEntries());
        for (CertPath certPath : jarCertVerifier.getCertsList()) {
            jarCertVerifier.setCurrentlyUsedCertPath(certPath);
            CertInformation certInformation = jarCertVerifier.getCertInformation(certPath);
            if (!this.hasCompletelySignedApp(certInformation, n)) continue;
            if (certInformation.isPublisherAlreadyTrusted()) {
                return;
            }
            SecurityDialogs.AccessType accessType = certInformation.isRootInCacerts() && !certInformation.hasSigningIssues() ? SecurityDialogs.AccessType.VERIFIED : (certInformation.isRootInCacerts() ? SecurityDialogs.AccessType.SIGNING_ERROR : SecurityDialogs.AccessType.UNVERIFIED);
            boolean bl = SecurityDialogs.showCertWarningDialog(accessType, jNLPFile, jarCertVerifier);
            if (!bl) continue;
            return;
        }
        throw new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCancelOnUserRequest"), "");
    }

    public boolean hasCompletelySignedApp(CertInformation certInformation, int n) {
        return JarCertVerifier.getTotalJarEntries(certInformation.getSignedJars()) == n;
    }
}

