/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.net.URL;
import java.util.ArrayList;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.LocateJnlpClassLoader;

public class ManageJnlpResources {
    public static JARDesc[] findJars(JNLPClassLoader jNLPClassLoader, URL uRL, String string, Version version) {
        JNLPClassLoader jNLPClassLoader2 = LocateJnlpClassLoader.getLoaderByJnlpFile(jNLPClassLoader, uRL);
        if (jNLPClassLoader2 != null) {
            ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
            ResourcesDesc resourcesDesc = jNLPClassLoader2.getJNLPFile().getResources();
            for (JARDesc jARDesc : resourcesDesc.getJARs(string)) {
                if (version != null && !version.equals(jARDesc.getVersion())) continue;
                arrayList.add(jARDesc);
            }
            return arrayList.toArray(new JARDesc[arrayList.size()]);
        }
        return new JARDesc[0];
    }

    public static void removeCachedJars(JNLPClassLoader jNLPClassLoader, URL uRL, JARDesc[] jARDescArray) {
        JNLPClassLoader jNLPClassLoader2 = LocateJnlpClassLoader.getLoaderByJnlpFile(jNLPClassLoader, uRL);
        if (jNLPClassLoader2 != null) {
            jNLPClassLoader2.removeJars(jARDescArray);
        }
    }

    public static void downloadJars(JNLPClassLoader jNLPClassLoader, URL uRL, String string, Version version) {
        JNLPClassLoader jNLPClassLoader2 = LocateJnlpClassLoader.getLoaderByJnlpFile(jNLPClassLoader, uRL);
        if (jNLPClassLoader2 != null) {
            jNLPClassLoader2.initializeNewJarDownload(uRL, string, version);
        }
    }

    public static void loadExternalResouceToCache(JNLPClassLoader jNLPClassLoader, URL uRL, String string) {
        jNLPClassLoader.manageExternalJars(uRL, string, JNLPClassLoader.DownloadAction.DOWNLOAD_TO_CACHE);
    }

    public static void removeExternalCachedResource(JNLPClassLoader jNLPClassLoader, URL uRL, String string) {
        jNLPClassLoader.manageExternalJars(uRL, string, JNLPClassLoader.DownloadAction.REMOVE_FROM_CACHE);
    }

    public static boolean isExternalResourceCached(JNLPClassLoader jNLPClassLoader, URL uRL, String string) {
        return jNLPClassLoader.manageExternalJars(uRL, string, JNLPClassLoader.DownloadAction.CHECK_CACHE);
    }
}

