/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Window;
import java.io.File;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import javax.swing.event.EventListenerList;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.ShortcutDesc;
import net.sourceforge.jnlp.event.ApplicationEvent;
import net.sourceforge.jnlp.event.ApplicationListener;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.util.WeakList;
import net.sourceforge.jnlp.util.XDesktopEntry;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.awt.AppContext;

public class ApplicationInstance {
    private JNLPFile file;
    private ThreadGroup group;
    private ClassLoader loader;
    private AppContext appContext;
    private boolean stopped = false;
    private WeakList<Window> weakWindows = new WeakList();
    private EventListenerList listeners = new EventListenerList();
    private boolean isSigned = false;

    public ApplicationInstance(JNLPFile jNLPFile, ThreadGroup threadGroup, ClassLoader classLoader) {
        this.file = jNLPFile;
        this.group = threadGroup;
        this.loader = classLoader;
        this.isSigned = ((JNLPClassLoader)classLoader).getSigning();
        this.appContext = AppContext.getAppContext();
    }

    public void addApplicationListener(ApplicationListener applicationListener) {
        this.listeners.add(ApplicationListener.class, applicationListener);
    }

    public void removeApplicationListener(ApplicationListener applicationListener) {
        this.listeners.remove(ApplicationListener.class, applicationListener);
    }

    protected void fireDestroyed() {
        Object[] objectArray = this.listeners.getListenerList();
        ApplicationEvent applicationEvent = null;
        for (int i = objectArray.length - 1; i > 0; i -= 2) {
            if (applicationEvent == null) {
                applicationEvent = new ApplicationEvent(this);
            }
            ((ApplicationListener)objectArray[i]).applicationDestroyed(applicationEvent);
        }
    }

    public void initialize() {
        this.installEnvironment();
        this.addMenuAndDesktopEntries();
    }

    private void addMenuAndDesktopEntries() {
        XDesktopEntry xDesktopEntry = new XDesktopEntry(this.file);
        ShortcutDesc shortcutDesc = this.file.getInformation().getShortcut();
        File file = xDesktopEntry.getLinuxDesktopIconFile();
        if (file.exists()) {
            OutputController.getLogger().log("ApplicationInstance.addMenuAndDesktopEntries(): file - " + file.getAbsolutePath() + " already exists. Not proceeding with desktop additions");
            return;
        }
        if (this.shouldCreateShortcut(shortcutDesc)) {
            xDesktopEntry.createDesktopShortcut();
        }
        if (shortcutDesc != null && shortcutDesc.getMenu() != null) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "ApplicationInstance.addMenuAndDesktopEntries(): Adding menu entries NOT IMPLEMENTED");
        }
    }

    private boolean shouldCreateShortcut(ShortcutDesc shortcutDesc) {
        if (JNLPRuntime.isTrustAll()) {
            return shortcutDesc != null && shortcutDesc.onDesktop();
        }
        String string = JNLPRuntime.getConfiguration().getProperty("deployment.javaws.shortcut");
        boolean bl = false;
        if (string.equals("NEVER")) {
            bl = false;
        } else if (string.equals("ALWAYS")) {
            bl = true;
        } else if (string.equals("ASK_USER")) {
            if (SecurityDialogs.showAccessWarningDialog(SecurityDialogs.AccessType.CREATE_DESTKOP_SHORTCUT, this.file)) {
                bl = true;
            }
        } else if (string.equals("ASK_IF_HINTED")) {
            if (shortcutDesc != null && shortcutDesc.onDesktop() && SecurityDialogs.showAccessWarningDialog(SecurityDialogs.AccessType.CREATE_DESTKOP_SHORTCUT, this.file)) {
                bl = true;
            }
        } else if (string.equals("ALWAYS_IF_HINTED") && shortcutDesc != null && shortcutDesc.onDesktop()) {
            bl = true;
        }
        return bl;
    }

    public void finalize() {
        this.destroy();
    }

    void installEnvironment() {
        final PropertyDesc[] propertyDescArray = this.file.getResources().getProperties();
        CodeSource codeSource = new CodeSource((URL)null, (Certificate[])null);
        JNLPClassLoader jNLPClassLoader = (JNLPClassLoader)this.loader;
        SecurityDesc securityDesc = jNLPClassLoader.getSecurity();
        ProtectionDomain protectionDomain = new ProtectionDomain(codeSource, securityDesc.getPermissions(codeSource), null, null);
        AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
        PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (PropertyDesc propertyDesc : propertyDescArray) {
                    System.setProperty(propertyDesc.getKey(), propertyDesc.getValue());
                }
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction, accessControlContext);
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    public String getTitle() {
        return this.file.getTitle();
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.stopped) {
            return;
        }
        try {
            int n;
            for (Window window : this.weakWindows) {
                if (window == null) continue;
                window.dispose();
            }
            this.weakWindows.clear();
            Thread[] threadArray = new Thread[this.group.activeCount() * 2];
            int n2 = this.group.enumerate(threadArray);
            for (n = 0; n < n2; ++n) {
                OutputController.getLogger().log("Interrupt thread: " + threadArray[n]);
                threadArray[n].interrupt();
            }
            Thread.yield();
            n2 = this.group.enumerate(threadArray);
            for (n = 0; n < n2; ++n) {
                OutputController.getLogger().log("Stop thread: " + threadArray[n]);
                threadArray[n].stop();
            }
        }
        finally {
            this.stopped = true;
            this.fireDestroyed();
        }
    }

    public ThreadGroup getThreadGroup() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.group;
    }

    public ClassLoader getClassLoader() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.loader;
    }

    protected void addWindow(Window window) {
        this.weakWindows.add(window);
        this.weakWindows.trimToSize();
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public AppContext getAppContext() {
        return this.appContext;
    }
}

