/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.AppletAudioClip;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.splashscreen.SplashController;
import net.sourceforge.jnlp.util.WeakList;
import net.sourceforge.jnlp.util.logging.OutputController;

public class AppletEnvironment
implements AppletContext,
AppletStub {
    private JNLPFile file;
    private Applet applet;
    private Map<String, String> parameters;
    private Container cont;
    private WeakList<AppletAudioClip> weakClips = new WeakList();
    private boolean appletStarted = false;
    private boolean destroyed = false;

    public AppletEnvironment(JNLPFile jNLPFile, AppletInstance appletInstance, Container container) {
        this.file = jNLPFile;
        this.applet = appletInstance.getApplet();
        this.parameters = jNLPFile.getApplet().getParameters();
        this.cont = container;
    }

    public AppletEnvironment(JNLPFile jNLPFile, final AppletInstance appletInstance) {
        this(jNLPFile, appletInstance, null);
        Frame frame = new Frame(jNLPFile.getApplet().getName() + " - Applet");
        frame.setResizable(false);
        appletInstance.addWindow(frame);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                appletInstance.destroy();
                JNLPRuntime.exit(0);
            }
        };
        frame.addWindowListener(windowAdapter);
        this.cont = frame;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("Illegal applet stub/context access: applet destroyed.");
        }
    }

    public void destroy() {
        this.destroyed = true;
        List<AppletAudioClip> list = this.weakClips.hardList();
        for (AppletAudioClip appletAudioClip : list) {
            appletAudioClip.dispose();
        }
    }

    public Container getAppletFrame() {
        return this.cont;
    }

    public SplashController getSplashControler() {
        return (SplashController)((Object)this.cont);
    }

    public void startApplet() {
        this.checkDestroyed();
        if (this.appletStarted) {
            return;
        }
        this.appletStarted = true;
        try {
            AppletDesc appletDesc = this.file.getApplet();
            if (this.cont instanceof AppletStub) {
                this.applet.setStub((AppletStub)((Object)this.cont));
            } else {
                this.applet.setStub(this);
            }
            this.cont.setLayout(new BorderLayout());
            this.cont.add("Center", this.applet);
            this.cont.validate();
            if (this.cont instanceof Frame) {
                Frame frame = (Frame)this.cont;
                frame.pack();
                Insets insets = frame.getInsets();
                frame.setSize(appletDesc.getWidth() + insets.left + insets.right, appletDesc.getHeight() + insets.top + insets.bottom);
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AppletEnvironment.this.cont.setVisible(true);
                        AppletEnvironment.this.applet.init();
                        AppletEnvironment.this.applet.start();
                        AppletEnvironment.this.cont.invalidate();
                        AppletEnvironment.this.cont.validate();
                        AppletEnvironment.this.cont.repaint();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
        }
    }

    @Override
    public Applet getApplet(String string) {
        this.checkDestroyed();
        if (string != null && string.equals(this.file.getApplet().getName())) {
            return this.applet;
        }
        return null;
    }

    public void setApplet(Applet applet) {
        if (this.applet != null) {
            OutputController.getLogger().log(new IllegalStateException("Applet can only be set once."));
            return;
        }
        this.applet = applet;
    }

    @Override
    public Enumeration<Applet> getApplets() {
        this.checkDestroyed();
        return Collections.enumeration(Arrays.asList(this.applet));
    }

    @Override
    public AudioClip getAudioClip(URL uRL) {
        this.checkDestroyed();
        AppletAudioClip appletAudioClip = new AppletAudioClip(uRL);
        this.weakClips.add(appletAudioClip);
        this.weakClips.trimToSize();
        return appletAudioClip;
    }

    @Override
    public Image getImage(URL uRL) {
        this.checkDestroyed();
        Image image = new ImageIcon(uRL).getImage();
        return image;
    }

    @Override
    public void showDocument(URL uRL) {
        this.checkDestroyed();
    }

    @Override
    public void showDocument(URL uRL, String string) {
        this.checkDestroyed();
    }

    @Override
    public void showStatus(String string) {
        this.checkDestroyed();
    }

    @Override
    public void setStream(String string, InputStream inputStream) {
        this.checkDestroyed();
    }

    @Override
    public InputStream getStream(String string) {
        this.checkDestroyed();
        return null;
    }

    @Override
    public Iterator<String> getStreamKeys() {
        this.checkDestroyed();
        return null;
    }

    @Override
    public void appletResize(int n, int n2) {
        this.checkDestroyed();
        if (this.cont instanceof Frame) {
            Frame frame = (Frame)this.cont;
            Insets insets = frame.getInsets();
            frame.setSize(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        }
    }

    @Override
    public AppletContext getAppletContext() {
        this.checkDestroyed();
        return this;
    }

    @Override
    public URL getCodeBase() {
        this.checkDestroyed();
        return this.file.getCodeBase();
    }

    @Override
    public URL getDocumentBase() {
        this.checkDestroyed();
        return this.file.getApplet().getDocumentBase();
    }

    @Override
    public String getParameter(String string) {
        this.checkDestroyed();
        String string2 = this.parameters.get(string);
        if (string2 != null) {
            return string2;
        }
        return this.parameters.get(string.toLowerCase());
    }

    @Override
    public boolean isActive() {
        this.checkDestroyed();
        return true;
    }
}

