/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jnlp.cache.LruCacheException;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.PropertiesFile;
import net.sourceforge.jnlp.util.logging.OutputController;

public enum CacheLRUWrapper {
    INSTANCE;

    private int lockCount = 0;
    private FileLock fl = null;
    private final String setCachePath = JNLPRuntime.getConfiguration().getProperty("deployment.user.cachedir");
    String cacheDir = new File(this.setCachePath != null ? this.setCachePath : System.getProperty("java.io.tmpdir")).getPath();
    PropertiesFile cacheOrder = new PropertiesFile(new File(this.cacheDir + File.separator + "recently_used"));
    public static final String CACHE_INDEX_FILE_NAME = "recently_used";

    private CacheLRUWrapper() {
        File file = this.cacheOrder.getStoreFile();
        if (!file.exists()) {
            try {
                FileUtils.createParentDir(file);
                FileUtils.createRestrictedFile(file, true);
            }
            catch (IOException iOException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
            }
        }
    }

    public static CacheLRUWrapper getInstance() {
        return INSTANCE;
    }

    public synchronized void load() {
        boolean bl = this.cacheOrder.load();
        if (bl && this.checkData()) {
            OutputController.getLogger().log(new LruCacheException());
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CFakeCache"));
            this.store();
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CFakedCache"));
        }
    }

    private boolean checkData() {
        boolean bl = false;
        Set set = this.cacheOrder.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            try {
                String[] stringArray = string.split(",");
                Long l = Long.parseLong(stringArray[0]);
                Long l2 = Long.parseLong(stringArray[1]);
            }
            catch (Exception exception) {
                iterator.remove();
                bl = true;
                continue;
            }
            if (string2 != null) {
                if (string2.indexOf(this.cacheDir) >= 0) continue;
                iterator.remove();
                bl = true;
                continue;
            }
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public synchronized void store() {
        this.cacheOrder.store();
    }

    public synchronized boolean addEntry(String string, String string2) {
        if (this.cacheOrder.containsKey(string)) {
            return false;
        }
        this.cacheOrder.setProperty(string, string2);
        return true;
    }

    public synchronized boolean removeEntry(String string) {
        if (!this.cacheOrder.containsKey(string)) {
            return false;
        }
        this.cacheOrder.remove(string);
        return true;
    }

    private String getIdForCacheFolder(String string) {
        int n = this.cacheDir.length();
        int n2 = string.indexOf(File.separatorChar, n + 1);
        return string.substring(n + 1, n2);
    }

    public synchronized boolean updateEntry(String string) {
        if (!this.cacheOrder.containsKey(string)) {
            return false;
        }
        String string2 = this.cacheOrder.getProperty(string);
        String string3 = this.getIdForCacheFolder(string2);
        this.cacheOrder.remove(string);
        this.cacheOrder.setProperty(Long.toString(System.currentTimeMillis()) + "," + string3, string2);
        return true;
    }

    public synchronized List<Map.Entry<String, String>> getLRUSortedEntries() {
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(this.cacheOrder.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> entry, Map.Entry<String, String> entry2) {
                Long l;
                Long l2 = Long.parseLong(entry.getKey().split(",")[0]);
                int n = l2.compareTo(l = Long.valueOf(Long.parseLong(entry2.getKey().split(",")[0])));
                return n < 0 ? 1 : (n > 0 ? -1 : 0);
            }
        });
        return arrayList;
    }

    public synchronized void lock() {
        try {
            this.fl = FileUtils.getFileLock(this.cacheOrder.getStoreFile().getPath(), false, true);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
        }
        if (this.fl != null) {
            ++this.lockCount;
        }
    }

    public synchronized void unlock() {
        if (this.fl != null) {
            --this.lockCount;
            try {
                if (this.lockCount == 0) {
                    this.fl.release();
                    this.fl.channel().close();
                    this.fl = null;
                }
            }
            catch (IOException iOException) {
                OutputController.getLogger().log(iOException);
            }
        }
    }

    public synchronized String getValue(String string) {
        return this.cacheOrder.getProperty(string);
    }

    public synchronized boolean contains(String string) {
        return this.cacheOrder.contains(string);
    }

    public String generateKey(String string) {
        return System.currentTimeMillis() + "," + this.getIdForCacheFolder(string);
    }

    void clearLRUSortedEntries() {
        this.cacheOrder.clear();
    }
}

