/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.jnlp.util.logging.OutputController;

public class HTMLPanel
extends JPanel {
    private String id;

    public HTMLPanel(URL uRL, String string) {
        super(new BorderLayout());
        this.id = string;
        JEditorPane jEditorPane = new JEditorPane();
        try {
            jEditorPane = new JEditorPane(uRL);
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
        }
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new UrlHyperlinkListener());
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        this.add((Component)jScrollPane, "Center");
    }

    public String getIdentifier() {
        return this.id;
    }

    private class UrlHyperlinkListener
    implements HyperlinkListener {
        private UrlHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (Desktop.isDesktopSupported() && hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

