/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Version {
    private static String seperators = ".-_";
    private static String emptyString = new String("<EMPTY>");
    private String versionString;

    public Version(String string) {
        this.versionString = string;
    }

    public boolean isVersionId() {
        return -1 == this.versionString.indexOf(" ");
    }

    public boolean matches(String string) {
        return this.matches(new Version(string));
    }

    public boolean matches(Version version) {
        List<String> list = version.getVersionStrings();
        for (int i = 0; i < list.size(); ++i) {
            if (this.matchesSingle(list.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesAny(String string) {
        return this.matches(new Version(string));
    }

    public boolean matchesAny(Version version) {
        List<String> list = version.getVersionStrings();
        for (int i = 0; i < list.size(); ++i) {
            if (!this.matchesSingle(list.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean matchesSingle(String string) {
        List<String> list = this.getVersionStrings();
        for (int i = 0; i < list.size(); ++i) {
            if (!this.matches(string, list.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String string, String string2) {
        List<String> list = this.getParts(string);
        List<String> list2 = this.getParts(string2);
        int n = Math.max(string.length(), string2.length());
        if (string2.endsWith("*")) {
            n = list2.size();
        }
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        arrayList.add(list);
        arrayList.add(list2);
        this.normalize(arrayList, n);
        if (this.equal(list, list2)) {
            return true;
        }
        return string2.endsWith("+") && this.greater(list, list2);
    }

    protected boolean equal(List<String> list, List<String> list2) {
        for (int i = 0; i < list.size(); ++i) {
            if (0 == this.compare(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean greater(List<String> list, List<String> list2) {
        for (int i = 0; i < list.size(); ++i) {
            if (this.compare(list.get(i), list2.get(i)) > 0) {
                return true;
            }
            if (this.compare(list.get(i), list2.get(i)) >= 0) continue;
            return false;
        }
        return false;
    }

    protected int compare(String string, String string2) {
        Integer n = 0;
        Integer n2 = 0;
        try {
            if (string != emptyString) {
                n = Integer.valueOf(string);
            }
            if (string2 != emptyString) {
                n2 = Integer.valueOf(string2);
            }
            return n.compareTo(n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (string == emptyString) {
                string = "";
            }
            if (string2 == emptyString) {
                string2 = "";
            }
            return string.compareTo(string2);
        }
    }

    protected void normalize(List<List<String>> list, int n) {
        int n2 = 0;
        for (List<String> list2 : list) {
            n2 = Math.max(n2, list2.size());
        }
        if (n2 > n) {
            n2 = n;
        }
        for (List<String> list2 : list) {
            while (list2.size() > n2) {
                list2.remove(list2.size() - 1);
            }
            while (list2.size() < n2) {
                list2.add(emptyString);
            }
        }
    }

    protected List<String> getVersionStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.versionString, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    protected List<String> getParts(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, seperators + "+*");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public String toString() {
        return this.versionString;
    }
}

