/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPCreator;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PluginParameters;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.misc.BASE64Decoder;

public class PluginBridge
extends JNLPFile {
    private PluginParameters params;
    private Set<String> jars = new HashSet<String>();
    private List<ExtensionDesc> extensionJars = new ArrayList<ExtensionDesc>();
    private List<String> codeBaseFolders = new ArrayList<String>();
    private String[] cacheJars = new String[0];
    private String[] cacheExJars = new String[0];
    private boolean usePack;
    private boolean useVersion;
    private boolean useJNLPHref;

    public PluginBridge(URL uRL, URL uRL2, String string, String string2, int n, int n2, PluginParameters pluginParameters) throws Exception {
        this(uRL, uRL2, string, string2, n, n2, pluginParameters, new JNLPCreator());
    }

    private void addArchiveEntries(String[] stringArray) {
        for (String string : stringArray) {
            if ((string = string.trim()).endsWith("/") || string.endsWith(File.pathSeparator)) {
                this.codeBaseFolders.add(string);
                continue;
            }
            this.jars.add(string);
        }
    }

    public PluginBridge(URL uRL, URL uRL2, String string, String string2, int n, int n2, PluginParameters pluginParameters, JNLPCreator jNLPCreator) throws Exception {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.specVersion = new Version("1.0");
        this.fileVersion = new Version("1.1");
        this.codeBase = uRL;
        this.sourceLocation = uRL2;
        this.params = pluginParameters;
        this.parserSettings = ParserSettings.getGlobalParserSettings();
        if (pluginParameters.getJNLPHref() != null) {
            this.useJNLPHref = true;
            try {
                JARDesc[] jARDescArray;
                object4 = new ParserSettings();
                object3 = new URL(this.codeBase, pluginParameters.getJNLPHref());
                object2 = null;
                if (pluginParameters.getJNLPEmbedded() != null) {
                    object = new ByteArrayInputStream(PluginBridge.decodeBase64String(pluginParameters.getJNLPEmbedded()));
                    object2 = new JNLPFile((InputStream)object, this.codeBase, (ParserSettings)object4);
                } else {
                    object2 = jNLPCreator.create((URL)object3, null, (ParserSettings)object4, JNLPRuntime.getDefaultUpdatePolicy(), this.codeBase);
                }
                if (((JNLPFile)object2).isApplet()) {
                    string2 = ((JNLPFile)object2).getApplet().getMainClass();
                }
                object = ((JNLPFile)object2).getApplet().getParameters();
                this.info = ((JNLPFile)object2).info;
                JARDesc[] jARDescArray2 = object.entrySet().iterator();
                while (jARDescArray2.hasNext()) {
                    jARDescArray = jARDescArray2.next();
                    this.params.put(((String)jARDescArray.getKey()).toLowerCase(), (String)jARDescArray.getValue());
                }
                jARDescArray = jARDescArray2 = ((JNLPFile)object2).getResources().getJARs();
                int n3 = jARDescArray.length;
                for (int i = 0; i < n3; ++i) {
                    stringArray = jARDescArray[i];
                    String string3 = stringArray.getLocation().toExternalForm();
                    this.jars.add(string3);
                }
                this.extensionJars = Arrays.asList(((JNLPFile)object2).getResources().getExtensions());
            }
            catch (MalformedURLException malformedURLException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to get JNLP file at: " + pluginParameters.getJNLPHref() + " with context of URL as: " + this.codeBase.toExternalForm());
            }
        } else {
            this.info = new ArrayList();
            this.useJNLPHref = false;
        }
        if (!((String)(object4 = pluginParameters.getCacheArchive())).isEmpty()) {
            object3 = new String[]{};
            object2 = pluginParameters.getCacheVersion();
            if (!((String)object2).isEmpty()) {
                object3 = ((String)object2).split(",");
            }
            object = ((String)object4).split(",");
            this.cacheJars = new String[((String[])object).length];
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.cacheJars[i] = ((String)object[i]).trim();
                if (((Object)object3).length <= 0) continue;
                int n4 = i;
                this.cacheJars[n4] = this.cacheJars[n4] + ";" + ((String)object3[i]).trim();
            }
        }
        if (!((String)(object3 = pluginParameters.getCacheArchiveEx())).isEmpty()) {
            this.cacheExJars = ((String)object3).split(",");
        }
        if (string != null && string.length() > 0) {
            object2 = string.split(",");
            this.addArchiveEntries((String[])object2);
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Jar string: " + string);
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "jars length: " + ((Object)object2).length);
        }
        if (string2.endsWith(".class")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        object2 = string2.replace('/', '.');
        this.launchType = new AppletDesc(this.getTitle(), (String)object2, uRL2, n, n2, pluginParameters.getUnmodifiableMap());
        this.security = string2.endsWith(".class") ? new SecurityDesc(this, SecurityDesc.SANDBOX_PERMISSIONS, uRL.getHost()) : null;
        this.uniqueKey = pluginParameters.getUniqueKey(uRL);
        this.usePack = false;
        this.useVersion = false;
        object = pluginParameters.getJavaArguments();
        if (!((String)object).isEmpty()) {
            for (String string4 : ((String)object).split(" ")) {
                stringArray = string4.trim().split("=");
                if (stringArray.length != 2 || !Boolean.valueOf(stringArray[1]).booleanValue()) continue;
                if ("-Djnlp.packEnabled".equals(stringArray[0])) {
                    this.usePack = true;
                    continue;
                }
                if (!"-Djnlp.versionEnabled".equals(stringArray[0])) continue;
                this.useVersion = true;
            }
        }
    }

    public List<String> getArchiveJars() {
        return new ArrayList<String>(this.jars);
    }

    public boolean codeBaseLookup() {
        return this.params.useCodebaseLookup();
    }

    public boolean useJNLPHref() {
        return this.useJNLPHref;
    }

    @Override
    public DownloadOptions getDownloadOptions() {
        return new DownloadOptions(this.usePack, this.useVersion);
    }

    @Override
    public String getTitle() {
        String string = super.getTitleFromManifest();
        if (string != null) {
            return string;
        }
        String string2 = this.getManifestsAttributes().getMainClass();
        if (string2 != null) {
            return string2;
        }
        return this.params.getAppletTitle();
    }

    @Override
    public ResourcesDesc getResources(Locale locale, String string, String string2) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{string}, new String[]{string2}){

            @Override
            public <T> List<T> getResources(Class<T> clazz) {
                if (clazz.equals(JARDesc.class)) {
                    try {
                        Version version;
                        String string;
                        String[] stringArray;
                        ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
                        arrayList.addAll(PluginBridge.this.sharedResources.getResources(JARDesc.class));
                        for (String object2 : PluginBridge.this.jars) {
                            if (object2.length() <= 0) continue;
                            arrayList.add(new JARDesc(new URL(PluginBridge.this.codeBase, object2), null, null, false, true, false, true));
                        }
                        boolean bl = true;
                        if (PluginBridge.this.params.getCacheOption().equalsIgnoreCase("no")) {
                            bl = false;
                        }
                        for (String string2 : PluginBridge.this.cacheJars) {
                            stringArray = string2.split(";");
                            string = stringArray[0];
                            version = null;
                            if (string.length() == 0) continue;
                            if (stringArray.length > 1) {
                                version = new Version(stringArray[1]);
                            }
                            arrayList.add(new JARDesc(new URL(PluginBridge.this.codeBase, string), version, null, false, true, false, bl));
                        }
                        for (String string2 : PluginBridge.this.cacheExJars) {
                            if (string2.length() == 0) continue;
                            stringArray = string2.split(";");
                            string = stringArray[0].trim();
                            version = null;
                            boolean bl2 = true;
                            if (stringArray.length > 1) {
                                if (stringArray[1].equals("preload")) {
                                    bl2 = false;
                                } else {
                                    version = new Version(stringArray[1].trim());
                                }
                                if (stringArray.length > 2) {
                                    bl2 = false;
                                    version = new Version(stringArray[2].trim());
                                }
                            }
                            arrayList.add(new JARDesc(new URL(PluginBridge.this.codeBase, string), version, null, bl2, true, false, false));
                        }
                        ArrayList<JARDesc> arrayList2 = arrayList;
                        return arrayList2;
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else if (clazz.equals(ExtensionDesc.class)) {
                    List list = PluginBridge.this.extensionJars;
                    return list;
                }
                return PluginBridge.this.sharedResources.getResources(clazz);
            }

            @Override
            public JARDesc[] getJARs() {
                List<JARDesc> list = this.getResources(JARDesc.class);
                return list.toArray(new JARDesc[list.size()]);
            }

            @Override
            public void addResource(Object object) {
                PluginBridge.this.sharedResources.addResource(object);
            }
        };
    }

    public List<String> getCodeBaseFolders() {
        return new ArrayList<String>(this.codeBaseFolders);
    }

    @Override
    public ResourcesDesc[] getResourcesDescs(Locale locale, String string, String string2) {
        return new ResourcesDesc[]{this.getResources(locale, string, string2)};
    }

    @Override
    public boolean isApplet() {
        return true;
    }

    @Override
    public boolean isApplication() {
        return false;
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isInstaller() {
        return false;
    }

    static byte[] decodeBase64String(String string) throws IOException {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        return bASE64Decoder.decodeBuffer(string);
    }
}

