/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.jnlp.Launcher;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.PluginParameters;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.splashscreen.SplashController;
import net.sourceforge.jnlp.splashscreen.SplashPanel;
import net.sourceforge.jnlp.splashscreen.SplashUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.AppletViewerPanel;
import sun.awt.SunToolkit;

public class NetxPanel
extends AppletViewerPanel
implements SplashController {
    private final PluginParameters parameters;
    private PluginBridge bridge = null;
    private AppletInstance appInst = null;
    private SplashController splashController;
    private volatile boolean initialized;
    private static final Map<String, ThreadGroup> uKeyToTG = new HashMap<String, ThreadGroup>();
    private static final Object TGMapMutex = new Object();
    private static final ConcurrentMap<String, Boolean> appContextCreated = new ConcurrentHashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetxPanel(URL uRL, PluginParameters pluginParameters) {
        super(uRL, pluginParameters.getUnderlyingHashtable());
        this.parameters = pluginParameters;
        this.initialized = false;
        String string = pluginParameters.getUniqueKey(this.getCodeBase());
        Object object = TGMapMutex;
        synchronized (object) {
            if (!uKeyToTG.containsKey(string)) {
                ThreadGroup threadGroup = new ThreadGroup(Launcher.mainGroup, this.documentURL.toString());
                uKeyToTG.put(string, threadGroup);
            }
        }
    }

    @Override
    protected void showAppletException(Throwable throwable) {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, throwable);
        super.showAppletException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runLoader() {
        try {
            this.bridge = new PluginBridge(this.baseURL, this.getDocumentBase(), this.getJarFiles(), this.getCode(), this.getWidth(), this.getHeight(), this.parameters);
            this.doInit = true;
            this.dispatchAppletEvent(51235, null);
            this.status = 1;
            Launcher launcher2 = new Launcher(false);
            this.appInst = (AppletInstance)launcher2.launch(this.bridge, this);
            this.applet = this.appInst.getApplet();
            if (this.applet != null) {
                this.applet.setStub(this);
                this.applet.setVisible(false);
                this.add("Center", this.applet);
                this.showAppletStatus("loaded");
                this.validate();
            }
        }
        catch (Exception exception) {
            this.status = 7;
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            this.replaceSplash(SplashUtils.getErrorSplashScreen(this.getWidth(), this.getHeight(), exception));
        }
        finally {
            this.initialized = true;
            this.dispatchAppletEvent(51236, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void createAppletThread() {
        Object object = JNLPRuntime.initMutex;
        synchronized (object) {
            if (!JNLPRuntime.isInitialized()) {
                OutputController.getLogger().log("initializing JNLPRuntime...");
                JNLPRuntime.initialize(false);
            } else {
                OutputController.getLogger().log("JNLPRuntime already initialized");
            }
        }
        this.handler = new Thread(this.getThreadGroup(), this, "NetxPanelThread@" + this.documentURL);
        this.handler.start();
    }

    public void updateSizeInAtts(int n, int n2) {
        this.parameters.updateSize(n2, n);
    }

    public ClassLoader getAppletClassLoader() {
        return this.appInst.getClassLoader();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroup getThreadGroup() {
        Object object = TGMapMutex;
        synchronized (object) {
            return uKeyToTG.get(this.parameters.getUniqueKey(this.getCodeBase()));
        }
    }

    public void createNewAppContext() {
        if (Thread.currentThread().getThreadGroup() != this.getThreadGroup()) {
            throw new RuntimeException("createNewAppContext called from the wrong thread.");
        }
        if (null == appContextCreated.putIfAbsent(this.parameters.getUniqueKey(this.getCodeBase()), Boolean.TRUE)) {
            SunToolkit.createNewAppContext();
        }
    }

    public void setAppletViewerFrame(SplashController splashController) {
        this.splashController = splashController;
    }

    @Override
    public void removeSplash() {
        this.splashController.removeSplash();
    }

    @Override
    public void replaceSplash(SplashPanel splashPanel) {
        this.splashController.replaceSplash(splashPanel);
    }

    @Override
    public int getSplashWidth() {
        return this.splashController.getSplashWidth();
    }

    @Override
    public int getSplashHeigth() {
        return this.splashController.getSplashHeigth();
    }
}

