/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jnlp.JNLPFile;

public class LaunchException
extends Exception {
    private static final List<LaunchExceptionWithStamp> launchExceptionChain = Collections.synchronizedList(new LinkedList());
    private static final long serialVersionUID = 7283827853612357423L;
    private JNLPFile file;
    private String category;
    private String summary;
    private String description;
    private String severity;

    public LaunchException(JNLPFile jNLPFile, Exception exception, String string, String string2, String string3, String string4) {
        super(string + ": " + string2 + ": " + string3 + " " + (string4 == null ? "" : string4), exception);
        this.file = jNLPFile;
        this.category = string2;
        this.summary = string3;
        this.description = string4;
        this.severity = string;
        this.saveLaunchException(this);
    }

    public LaunchException(Throwable throwable) {
        super(throwable);
        this.saveLaunchException(this);
    }

    public LaunchException(String string, Throwable throwable) {
        super(string, throwable);
        this.saveLaunchException(this);
    }

    public LaunchException(String string) {
        super(string);
        this.saveLaunchException(this);
    }

    public JNLPFile getFile() {
        return this.file;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSeverity() {
        return this.severity;
    }

    private synchronized void saveLaunchException(LaunchException launchException) {
        launchExceptionChain.add(new LaunchExceptionWithStamp(launchException));
    }

    public static synchronized List<LaunchExceptionWithStamp> getLaunchExceptionChain() {
        return launchExceptionChain;
    }

    public static class LaunchExceptionWithStamp {
        private final LaunchException ex;
        private final Date stamp;

        private LaunchExceptionWithStamp(LaunchException launchException) {
            this.ex = launchException;
            this.stamp = new Date();
        }

        public LaunchException getEx() {
            return this.ex;
        }

        public Date getStamp() {
            return this.stamp;
        }
    }
}

