/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.splashscreen.SplashPanel;
import net.sourceforge.jnlp.splashscreen.SplashUtils;
import net.sourceforge.jnlp.splashscreen.parts.InformationElement;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.OutputController;

public class JNLPSplashScreen
extends JDialog {
    ResourceTracker resourceTracker;
    URL splashImageUrl;
    Image splashImage;
    private final JNLPFile file;
    public static final int DEF_WIDTH = 635;
    public static final int DEF_HEIGHT = 480;
    private SplashPanel componetSplash;
    private boolean splashImageLoaded = false;

    public JNLPSplashScreen(ResourceTracker resourceTracker, JNLPFile jNLPFile) {
        this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        this.resourceTracker = resourceTracker;
        this.file = jNLPFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSplashImageURL(URL uRL) {
        this.splashImageLoaded = false;
        try {
            if (uRL != null) {
                this.splashImageUrl = uRL;
                this.splashImage = null;
                try {
                    this.splashImage = ImageIO.read(this.resourceTracker.getCacheFile(this.splashImageUrl));
                    if (this.splashImage == null) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Error loading splash image: " + uRL);
                    }
                }
                catch (IOException iOException) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Error loading splash image: " + uRL);
                    this.splashImage = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Error loading splash image: " + uRL);
                    this.splashImage = null;
                }
            }
            if (this.splashImage == null) {
                this.setLayout(new BorderLayout());
                SplashPanel splashPanel = SplashUtils.getSplashScreen(635, 480);
                if (splashPanel != null) {
                    splashPanel.startAnimation();
                    splashPanel.setInformationElement(InformationElement.createFromJNLP(this.file));
                    this.add(splashPanel.getSplashComponent());
                    this.componetSplash = splashPanel;
                }
            }
            this.correctSize();
        }
        finally {
            this.splashImageLoaded = true;
        }
    }

    public boolean isSplashImageLoaded() {
        return this.splashImageLoaded;
    }

    public boolean isSplashScreenValid() {
        return this.splashImage != null || this.componetSplash != null;
    }

    private void correctSize() {
        int n = 635;
        int n2 = 480;
        if (this.splashImage != null) {
            Insets insets = this.getInsets();
            n = this.splashImage.getWidth(null) + insets.left + insets.right;
            n2 = this.splashImage.getHeight(null) + insets.top + insets.bottom;
        }
        this.setMinimumSize(new Dimension(0, 0));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.setSize(new Dimension(n, n2));
        this.setPreferredSize(new Dimension(n, n2));
        ScreenFinder.centerWindowsToCurrentScreen(this);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.splashImage == null) {
            super.paint(graphics);
            return;
        }
        this.correctSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage(this.splashImage, this.getInsets().left, this.getInsets().top, null);
    }

    public boolean isCustomSplashscreen() {
        return this.componetSplash != null;
    }

    public void stopAnimation() {
        if (this.isCustomSplashscreen()) {
            this.componetSplash.stopAnimation();
        }
    }
}

