/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.ComponentDesc;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.InstallerDesc;
import net.sourceforge.jnlp.JREDesc;
import net.sourceforge.jnlp.LaunchDesc;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.Parser;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.UpdateDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public class JNLPFile {
    public static final String APP_NAME = "Application-Name";
    public static final String CALLER_ALLOWABLE = "Caller-Allowable-Codebase";
    public static final String APP_LIBRARY_ALLOWABLE = "Application-Library-Allowable-Codebase";
    protected URL sourceLocation = null;
    protected URL fileLocation;
    protected ParserSettings parserSettings = null;
    protected String uniqueKey = null;
    protected URL codeBase;
    protected Version fileVersion;
    protected Version specVersion;
    protected List<InformationDesc> info;
    protected UpdateDesc update;
    protected List<ResourcesDesc> resources;
    protected ResourcesDesc sharedResources = new ResourcesDesc(this, null, null, null);
    protected LaunchDesc launchType;
    protected ComponentDesc component;
    protected SecurityDesc security;
    protected Locale defaultLocale = null;
    protected String defaultOS = null;
    protected String defaultArch = null;
    private boolean missingSignedJNLP = false;
    private boolean containsSpecialProperties = false;
    private String[] generalProperties = SecurityDesc.getJnlpRIAPermissions();
    private final ManifestsAttributes manifestsAttributes = new ManifestsAttributes();
    public static final String TITLE_NOT_FOUND = "Application title was not found in manifest. Check with application vendor";

    protected JNLPFile() {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public JNLPFile(URL uRL) throws IOException, ParseException {
        this(uRL, new ParserSettings());
    }

    public JNLPFile(URL uRL, ParserSettings parserSettings) throws IOException, ParseException {
        this(uRL, (Version)null, parserSettings);
    }

    public JNLPFile(URL uRL, Version version, ParserSettings parserSettings) throws IOException, ParseException {
        this(uRL, version, parserSettings, JNLPRuntime.getDefaultUpdatePolicy());
    }

    public JNLPFile(URL uRL, Version version, ParserSettings parserSettings, UpdatePolicy updatePolicy) throws IOException, ParseException {
        this(uRL, version, parserSettings, updatePolicy, null);
    }

    protected JNLPFile(URL uRL, Version version, ParserSettings parserSettings, UpdatePolicy updatePolicy, URL uRL2) throws IOException, ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        InputStream inputStream = JNLPFile.openURL(uRL, version, updatePolicy);
        this.parserSettings = parserSettings;
        this.parse(inputStream, uRL, uRL2);
        if (this.sourceLocation != null && "file".equals(uRL.getProtocol())) {
            JNLPFile.openURL(this.sourceLocation, version, updatePolicy);
        }
        this.fileLocation = uRL;
        this.uniqueKey = Calendar.getInstance().getTimeInMillis() + "-" + (int)(Math.random() * 2.147483647E9) + "-" + uRL;
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "UNIQUEKEY=" + this.uniqueKey);
    }

    public JNLPFile(URL uRL, String string, Version version, ParserSettings parserSettings, UpdatePolicy updatePolicy) throws IOException, ParseException {
        this(uRL, version, parserSettings, updatePolicy);
        this.uniqueKey = string;
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "UNIQUEKEY (override) =" + this.uniqueKey);
    }

    public JNLPFile(InputStream inputStream, ParserSettings parserSettings) throws ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.parserSettings = parserSettings;
        this.parse(inputStream, null, null);
    }

    public JNLPFile(InputStream inputStream, URL uRL, ParserSettings parserSettings) throws ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.parserSettings = parserSettings;
        this.parse(inputStream, null, uRL);
    }

    private static InputStream openURL(URL uRL, Version version, UpdatePolicy updatePolicy) throws IOException {
        if (uRL == null || updatePolicy == null) {
            throw new IllegalArgumentException(Translator.R("NullParameter"));
        }
        try {
            ResourceTracker resourceTracker = new ResourceTracker(false);
            resourceTracker.addResource(uRL, version, null, updatePolicy);
            return resourceTracker.getInputStream(uRL);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public String getTitle() {
        String string = this.getTitleFromJnlp();
        String string2 = this.getTitleFromManifest();
        if (string != null && string2 != null) {
            if (string.equals(string2)) {
                return string;
            }
            return string + " (" + string2 + ")";
        }
        if (string != null && string2 == null) {
            return string;
        }
        if (string == null && string2 != null) {
            return string2;
        }
        String string3 = this.getManifestsAttributes().getMainClass();
        return string3;
    }

    public String getTitleFromJnlp() {
        return this.getInformation().getTitle();
    }

    public String getTitleFromManifest() {
        String string = this.getManifestsAttributes().getApplicationName();
        if (string == null && this.getManifestsAttributes().isLoader()) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, TITLE_NOT_FOUND);
        }
        return string;
    }

    public String getVendor() {
        return this.getInformation().getVendor();
    }

    public URL getSourceLocation() {
        return this.sourceLocation;
    }

    public URL getFileLocation() {
        return this.fileLocation;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public ParserSettings getParserSettings() {
        return this.parserSettings;
    }

    public Version getFileVersion() {
        return this.fileVersion;
    }

    public Version getSpecVersion() {
        return this.specVersion;
    }

    public URL getCodeBase() {
        return this.codeBase;
    }

    public InformationDesc getInformation() {
        return this.getInformation(this.defaultLocale);
    }

    public InformationDesc getInformation(final Locale locale) {
        return new InformationDesc(new Locale[]{locale}){

            @Override
            protected List<Object> getItems(Object object) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Match match : Match.values()) {
                    for (InformationDesc informationDesc : JNLPFile.this.info) {
                        if (!JNLPFile.this.localeMatches(locale, informationDesc.getLocales(), match)) continue;
                        arrayList.addAll(informationDesc.getItems(object));
                    }
                    if (arrayList.size() <= 0) continue;
                    return arrayList;
                }
                return arrayList;
            }

            @Override
            public String getTitle() {
                for (Match match : Match.values()) {
                    for (InformationDesc informationDesc : JNLPFile.this.info) {
                        String string = informationDesc.getTitle();
                        if (!JNLPFile.this.localeMatches(locale, informationDesc.getLocales(), match) || string == null || "".equals(string)) continue;
                        return string;
                    }
                }
                return null;
            }

            @Override
            public String getVendor() {
                for (Match match : Match.values()) {
                    for (InformationDesc informationDesc : JNLPFile.this.info) {
                        String string = informationDesc.getVendor();
                        if (!JNLPFile.this.localeMatches(locale, informationDesc.getLocales(), match) || string == null || "".equals(string)) continue;
                        return string;
                    }
                }
                return null;
            }
        };
    }

    public UpdateDesc getUpdate() {
        return this.update;
    }

    public SecurityDesc getSecurity() {
        return this.security;
    }

    public ResourcesDesc getResources() {
        return this.getResources(this.defaultLocale, this.defaultOS, this.defaultArch);
    }

    public ResourcesDesc getResources(final Locale locale, final String string, final String string2) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{string}, new String[]{string2}){

            @Override
            public <T> List<T> getResources(Class<T> clazz) {
                ArrayList<T> arrayList = new ArrayList<T>();
                for (ResourcesDesc resourcesDesc : JNLPFile.this.resources) {
                    boolean bl = false;
                    for (Match match : Match.values()) {
                        bl |= JNLPFile.this.localeMatches(locale, resourcesDesc.getLocales(), match);
                    }
                    if (!bl || !JNLPFile.this.stringMatches(string, resourcesDesc.getOS()) || !JNLPFile.this.stringMatches(string2, resourcesDesc.getArch())) continue;
                    arrayList.addAll(resourcesDesc.getResources(clazz));
                }
                arrayList.addAll(JNLPFile.this.sharedResources.getResources(clazz));
                return arrayList;
            }

            @Override
            public void addResource(Object object) {
                JNLPFile.this.sharedResources.addResource(object);
            }
        };
    }

    public ResourcesDesc[] getResourcesDescs() {
        return this.getResourcesDescs(this.defaultLocale, this.defaultOS, this.defaultArch);
    }

    public ResourcesDesc[] getResourcesDescs(Locale locale, String string, String string2) {
        ArrayList<ResourcesDesc> arrayList = new ArrayList<ResourcesDesc>();
        for (ResourcesDesc resourcesDesc : this.resources) {
            boolean bl = false;
            for (Match match : Match.values()) {
                bl |= this.localeMatches(locale, resourcesDesc.getLocales(), match);
            }
            if (!bl || !this.stringMatches(string, resourcesDesc.getOS()) || !this.stringMatches(string2, resourcesDesc.getArch())) continue;
            arrayList.add(resourcesDesc);
        }
        return arrayList.toArray(new ResourcesDesc[0]);
    }

    public LaunchDesc getLaunchInfo() {
        return this.launchType;
    }

    public AppletDesc getApplet() {
        if (!this.isApplet()) {
            throw new UnsupportedOperationException(Translator.R("JNotApplet"));
        }
        return (AppletDesc)this.launchType;
    }

    public ApplicationDesc getApplication() {
        if (!this.isApplication()) {
            throw new UnsupportedOperationException(Translator.R("JNotApplication"));
        }
        return (ApplicationDesc)this.launchType;
    }

    public ComponentDesc getComponent() {
        if (!this.isComponent()) {
            throw new UnsupportedOperationException(Translator.R("JNotComponent"));
        }
        return this.component;
    }

    public InstallerDesc getInstaller() {
        if (!this.isInstaller()) {
            throw new UnsupportedOperationException(Translator.R("NotInstaller"));
        }
        return (InstallerDesc)this.launchType;
    }

    public boolean isApplet() {
        return this.launchType instanceof AppletDesc;
    }

    public boolean isApplication() {
        return this.launchType instanceof ApplicationDesc;
    }

    public boolean isComponent() {
        return this.component != null;
    }

    public boolean isInstaller() {
        return this.launchType instanceof InstallerDesc;
    }

    public void setDefaults(String string, String string2, Locale locale) {
        this.defaultOS = string;
        this.defaultArch = string2;
        this.defaultLocale = locale;
    }

    public boolean localeMatches(Locale locale, Locale[] localeArray, Match match) {
        if (match == Match.GENERALIZED) {
            return localeArray == null || localeArray.length == 0;
        }
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        block5: for (Locale locale2 : localeArray) {
            switch (match) {
                case LANG: {
                    if (string.isEmpty() || !string.equals(locale2.getLanguage()) || !locale2.getCountry().isEmpty() || !locale2.getVariant().isEmpty()) continue block5;
                    return true;
                }
                case LANG_COUNTRY: {
                    if (string.isEmpty() || !string.equals(locale2.getLanguage()) || string2.isEmpty() || !string2.equals(locale2.getCountry()) || !locale2.getVariant().isEmpty()) continue block5;
                    return true;
                }
                case LANG_COUNTRY_VARIANT: {
                    if (!string.equals(locale2.getLanguage()) || !string2.equals(locale2.getCountry()) || !string3.equals(locale2.getVariant())) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean stringMatches(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !stringArray[i].startsWith(string)) continue;
            return true;
        }
        return false;
    }

    private void parse(InputStream inputStream, URL uRL, URL uRL2) throws ParseException {
        try {
            Node node = Parser.getRootNode(inputStream, this.parserSettings);
            Parser parser = new Parser(this, uRL, node, this.parserSettings, uRL2);
            this.specVersion = parser.getSpecVersion();
            this.fileVersion = parser.getFileVersion();
            this.codeBase = parser.getCodeBase();
            this.sourceLocation = parser.getFileLocation() != null ? parser.getFileLocation() : uRL;
            this.info = parser.getInfo(node);
            parser.checkForInformation();
            this.update = parser.getUpdate(node);
            this.resources = parser.getResources(node, false);
            this.launchType = parser.getLauncher(node);
            this.component = parser.getComponent(node);
            this.security = parser.getSecurity(node);
            this.checkForSpecialProperties();
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
            throw new RuntimeException(exception.toString());
        }
    }

    private void checkForSpecialProperties() {
        for (ResourcesDesc resourcesDesc : this.resources) {
            for (PropertyDesc propertyDesc : resourcesDesc.getProperties()) {
                String string;
                for (int i = 0; i < this.generalProperties.length && !(string = propertyDesc.getKey()).equals(this.generalProperties[i]); ++i) {
                    if (string.equals(this.generalProperties[i]) || i != this.generalProperties.length - 1) continue;
                    this.containsSpecialProperties = true;
                    return;
                }
            }
        }
    }

    public boolean needsNewVM() {
        return this.getNewVMArgs().size() != 0;
    }

    public List<String> getNewVMArgs() {
        LinkedList<String> linkedList = new LinkedList<String>();
        JREDesc[] jREDescArray = this.getResources().getJREs();
        for (int i = 0; i < jREDescArray.length; ++i) {
            String string;
            String string2;
            String string3 = jREDescArray[i].getInitialHeapSize();
            if (string3 != null) {
                linkedList.add("-Xms" + string3);
            }
            if ((string2 = jREDescArray[i].getMaximumHeapSize()) != null) {
                linkedList.add("-Xmx" + string2);
            }
            if ((string = jREDescArray[i].getVMArgs()) == null) continue;
            String[] stringArray = string.split(" ");
            linkedList.addAll(Arrays.asList(stringArray));
        }
        return linkedList;
    }

    public DownloadOptions getDownloadOptions() {
        boolean bl = false;
        boolean bl2 = false;
        ResourcesDesc resourcesDesc = this.getResources();
        if (Boolean.valueOf(resourcesDesc.getPropertiesMap().get("jnlp.packEnabled")).booleanValue()) {
            bl = true;
        }
        if (Boolean.valueOf(resourcesDesc.getPropertiesMap().get("jnlp.versionEnabled")).booleanValue()) {
            bl2 = true;
        }
        return new DownloadOptions(bl, bl2);
    }

    public boolean requiresSignedJNLPWarning() {
        return this.missingSignedJNLP && this.containsSpecialProperties;
    }

    public void setSignedJNLPAsMissing() {
        this.missingSignedJNLP = true;
    }

    public ManifestsAttributes getManifestsAttributes() {
        return this.manifestsAttributes;
    }

    public class ManifestsAttributes {
        private JNLPClassLoader loader;

        public void setLoader(JNLPClassLoader jNLPClassLoader) {
            this.loader = jNLPClassLoader;
        }

        public boolean isLoader() {
            return this.loader != null;
        }

        public String getMainClass() {
            if (this.loader == null) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Jars not ready to provide main class");
                return null;
            }
            return this.loader.getMainClass();
        }

        public String getApplicationName() {
            return this.getAttribute(JNLPFile.APP_NAME);
        }

        public String getCallerAllowableCodebase() {
            return this.getAttribute(JNLPFile.CALLER_ALLOWABLE);
        }

        public String getApplicationLibraryAllowableCodebase() {
            return this.getAttribute(JNLPFile.APP_LIBRARY_ALLOWABLE);
        }

        public String getAttribute(String string) {
            return this.getAttribute(new Attributes.Name(string));
        }

        public String getAttribute(Attributes.Name name) {
            if (this.loader == null) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Jars not ready to provide attribute " + name);
                return null;
            }
            return this.loader.checkForAttributeInJars(Arrays.asList(JNLPFile.this.getResources().getJARs()), name);
        }
    }

    static enum Match {
        LANG_COUNTRY_VARIANT,
        LANG_COUNTRY,
        LANG,
        GENERALIZED;

    }
}

