/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.util.logging.OutputController;

public abstract class AbstractLaunchHandler
implements LaunchHandler {
    protected final OutputController logger;

    public AbstractLaunchHandler(OutputController outputController) {
        this.logger = outputController;
    }

    protected void printMessage(LaunchException launchException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("netx: ");
        stringBuilder.append(launchException.getCategory());
        if (launchException.getSummary() != null) {
            stringBuilder.append(": ");
            stringBuilder.append(launchException.getSummary());
        }
        if (launchException.getCause() != null) {
            stringBuilder.append(this.recursiveDescription(launchException.getCause()));
        }
        this.logger.log(OutputController.Level.MESSAGE_ALL, stringBuilder.toString());
        this.logger.log(launchException);
    }

    private String recursiveDescription(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" (");
        stringBuilder.append(throwable.getMessage() == null ? "" : throwable.getMessage());
        if (throwable.getCause() != null) {
            stringBuilder.append(this.recursiveDescription(throwable.getCause()));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

