/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

final class UNIXProcess
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final int pid;
    private int exitcode;
    private boolean hasExited;
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private static final LaunchMechanism launchMechanism = AccessController.doPrivileged(new PrivilegedAction<LaunchMechanism>(){

        @Override
        public LaunchMechanism run() {
            String string;
            String string2 = System.getProperty("java.home");
            String string3 = System.getProperty("os.name");
            if (string3.endsWith("BSD")) {
                string = System.getProperty("os.arch");
                UNIXProcess.access$002(UNIXProcess.toCString(string2 + "/lib/" + string + "/jspawnhelper"));
            } else {
                UNIXProcess.access$002(UNIXProcess.toCString(string2 + "/lib/jspawnhelper"));
            }
            string = System.getProperty("os.version");
            if (string3.startsWith("NetBSD") && string.startsWith("5")) {
                String string4 = System.getProperty("jdk.lang.Process.launchMechanism", "fork");
                try {
                    return LaunchMechanism.valueOf(string4.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Error(string4 + " is not a supported " + "process launch mechanism on this platform.");
                }
            }
            String string5 = System.getProperty("jdk.lang.Process.launchMechanism", "posix_spawn");
            try {
                return LaunchMechanism.valueOf(string5.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Error(string5 + " is not a supported " + "process launch mechanism on this platform.");
            }
        }
    });
    private static byte[] helperpath;
    private static final Executor processReaperExecutor;

    private static byte[] toCString(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }

    private native int waitForProcessExit(int var1);

    private native int forkAndExec(int var1, byte[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int[] var9, boolean var10) throws IOException;

    UNIXProcess(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2, byte[] byArray4, final int[] nArray, boolean bl) throws IOException {
        this.pid = this.forkAndExec(launchMechanism.value, helperpath, byArray, byArray2, n, byArray3, n2, byArray4, nArray, bl);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    UNIXProcess.this.initStreams(nArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    static FileDescriptor newFileDescriptor(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.set(fileDescriptor, n);
        return fileDescriptor;
    }

    void initStreams(int[] nArray) throws IOException {
        this.stdin = nArray[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new ProcessPipeOutputStream(nArray[0]);
        this.stdout = nArray[1] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(nArray[1]);
        this.stderr = nArray[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(nArray[2]);
        processReaperExecutor.execute(new Runnable(){

            @Override
            public void run() {
                int n = UNIXProcess.this.waitForProcessExit(UNIXProcess.this.pid);
                UNIXProcess.this.processExited(n);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processExited(int n) {
        UNIXProcess uNIXProcess = this;
        synchronized (uNIXProcess) {
            this.exitcode = n;
            this.hasExited = true;
            this.notifyAll();
        }
        if (this.stdout instanceof ProcessPipeInputStream) {
            ((ProcessPipeInputStream)this.stdout).processExited();
        }
        if (this.stderr instanceof ProcessPipeInputStream) {
            ((ProcessPipeInputStream)this.stderr).processExited();
        }
        if (this.stdin instanceof ProcessPipeOutputStream) {
            ((ProcessPipeOutputStream)this.stdin).processExited();
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    @Override
    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    private static native void destroyProcess(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        UNIXProcess uNIXProcess = this;
        synchronized (uNIXProcess) {
            if (!this.hasExited) {
                UNIXProcess.destroyProcess(this.pid);
            }
        }
        try {
            this.stdin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stdout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stderr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static native void init();

    static /* synthetic */ byte[] access$002(byte[] byArray) {
        helperpath = byArray;
        return byArray;
    }

    static {
        processReaperExecutor = AccessController.doPrivileged(new PrivilegedAction<Executor>(){

            @Override
            public Executor run() {
                return Executors.newCachedThreadPool(new ProcessReaperThreadFactory());
            }
        });
        UNIXProcess.init();
    }

    static class ProcessPipeOutputStream
    extends BufferedOutputStream {
        ProcessPipeOutputStream(int n) {
            super(new FileOutputStream(UNIXProcess.newFileDescriptor(n)));
        }

        synchronized void processExited() {
            OutputStream outputStream = this.out;
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.out = ProcessBuilder.NullOutputStream.INSTANCE;
            }
        }
    }

    static class ProcessPipeInputStream
    extends BufferedInputStream {
        private final Object closeLock = new Object();

        ProcessPipeInputStream(int n) {
            super(new FileInputStream(UNIXProcess.newFileDescriptor(n)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputStream drainInputStream(InputStream inputStream) throws IOException {
            int n;
            int n2 = 0;
            byte[] byArray = null;
            Object object = this.closeLock;
            synchronized (object) {
                if (this.buf == null) {
                    return null;
                }
                n = inputStream.available();
            }
            while (n > 0) {
                byArray = byArray == null ? new byte[n] : Arrays.copyOf(byArray, n2 + n);
                object = this.closeLock;
                synchronized (object) {
                    if (this.buf == null) {
                        return null;
                    }
                    n2 += inputStream.read(byArray, n2, n);
                    n = inputStream.available();
                }
            }
            return byArray == null ? ProcessBuilder.NullInputStream.INSTANCE : new ByteArrayInputStream(n2 == byArray.length ? byArray : Arrays.copyOf(byArray, n2));
        }

        synchronized void processExited() {
            try {
                InputStream inputStream = this.in;
                if (inputStream != null) {
                    InputStream inputStream2 = this.drainInputStream(inputStream);
                    inputStream.close();
                    this.in = inputStream2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                super.close();
            }
        }
    }

    private static class ProcessReaperThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup group = ProcessReaperThreadFactory.getRootThreadGroup();

        private ProcessReaperThreadFactory() {
        }

        private static ThreadGroup getRootThreadGroup() {
            return AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup.getParent() != null) {
                        threadGroup = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            });
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(group, runnable, "process reaper", 32768L);
            thread.setDaemon(true);
            thread.setPriority(10);
            return thread;
        }
    }

    private static enum LaunchMechanism {
        FORK(1),
        POSIX_SPAWN(2);

        private int value;

        private LaunchMechanism(int n2) {
            this.value = n2;
        }
    }
}

