/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.NegotiateAuthentication;
import sun.security.action.GetPropertyAction;

public class AuthenticationHeader {
    MessageHeader rsp;
    HeaderParser preferred;
    String preferred_r;
    private final HttpCallerInfo hci;
    boolean dontUseNegotiate = false;
    static String authPref = null;
    String hdrname;
    HashMap schemes;

    public String toString() {
        return "AuthenticationHeader: prefer " + this.preferred_r;
    }

    public AuthenticationHeader(String string, MessageHeader messageHeader, HttpCallerInfo httpCallerInfo, boolean bl) {
        this.hci = httpCallerInfo;
        this.dontUseNegotiate = bl;
        this.rsp = messageHeader;
        this.hdrname = string;
        this.schemes = new HashMap();
        this.parse();
    }

    public HttpCallerInfo getHttpCallerInfo() {
        return this.hci;
    }

    private void parse() {
        Object object;
        Object object2;
        Iterator<String> iterator = this.rsp.multiValueIterator(this.hdrname);
        while (iterator.hasNext()) {
            String string;
            HeaderParser headerParser;
            object2 = iterator.next();
            object = new HeaderParser((String)object2);
            Iterator iterator2 = ((HeaderParser)object).keys();
            int n = 0;
            int n2 = -1;
            while (iterator2.hasNext()) {
                iterator2.next();
                if (((HeaderParser)object).findValue(n) == null) {
                    if (n2 != -1) {
                        headerParser = ((HeaderParser)object).subsequence(n2, n);
                        string = headerParser.findKey(0);
                        this.schemes.put(string, new SchemeMapValue(headerParser, (String)object2));
                    }
                    n2 = n;
                }
                ++n;
            }
            if (n <= n2) continue;
            headerParser = ((HeaderParser)object).subsequence(n2, n);
            string = headerParser.findKey(0);
            this.schemes.put(string, new SchemeMapValue(headerParser, (String)object2));
        }
        object2 = null;
        if (authPref == null || (object2 = (SchemeMapValue)this.schemes.get(authPref)) == null) {
            if (object2 == null && !this.dontUseNegotiate && (object = (SchemeMapValue)this.schemes.get("negotiate")) != null) {
                if (this.hci == null || !NegotiateAuthentication.isSupported(new HttpCallerInfo(this.hci, "Negotiate"))) {
                    object = null;
                }
                object2 = object;
            }
            if (object2 == null && !this.dontUseNegotiate && (object = (SchemeMapValue)this.schemes.get("kerberos")) != null) {
                if (this.hci == null || !NegotiateAuthentication.isSupported(new HttpCallerInfo(this.hci, "Kerberos"))) {
                    object = null;
                }
                object2 = object;
            }
            if (object2 == null && (object2 = (SchemeMapValue)this.schemes.get("digest")) == null && (object2 = (SchemeMapValue)this.schemes.get("ntlm")) == null) {
                object2 = (SchemeMapValue)this.schemes.get("basic");
            }
        } else if (this.dontUseNegotiate && authPref.equals("negotiate")) {
            object2 = null;
        }
        if (object2 != null) {
            this.preferred = ((SchemeMapValue)object2).parser;
            this.preferred_r = ((SchemeMapValue)object2).raw;
        }
    }

    public HeaderParser headerParser() {
        return this.preferred;
    }

    public String scheme() {
        if (this.preferred != null) {
            return this.preferred.findKey(0);
        }
        return null;
    }

    public String raw() {
        return this.preferred_r;
    }

    public boolean isPresent() {
        return this.preferred != null;
    }

    static {
        authPref = AccessController.doPrivileged(new GetPropertyAction("http.auth.preference"));
        if (authPref != null && ((authPref = authPref.toLowerCase()).equals("spnego") || authPref.equals("kerberos"))) {
            authPref = "negotiate";
        }
    }

    static class SchemeMapValue {
        String raw;
        HeaderParser parser;

        SchemeMapValue(HeaderParser headerParser, String string) {
            this.raw = string;
            this.parser = headerParser;
        }
    }
}

