/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import sun.awt.AppContext;

class TimerQueue
implements Runnable {
    private static final Object sharedInstanceKey = new StringBuffer("TimerQueue.sharedInstanceKey");
    private static final Object expiredTimersKey = new StringBuffer("TimerQueue.expiredTimersKey");
    private final DelayQueue<DelayedTimer> queue = new DelayQueue();
    private volatile boolean running;
    private final Lock runningLock = new ReentrantLock();
    private static final Object classLock = new Object();
    private static final long NANO_ORIGIN = System.nanoTime();

    public TimerQueue() {
        this.startIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerQueue sharedInstance() {
        Object object = classLock;
        synchronized (object) {
            TimerQueue timerQueue = (TimerQueue)SwingUtilities.appContextGet(sharedInstanceKey);
            if (timerQueue == null) {
                timerQueue = new TimerQueue();
                SwingUtilities.appContextPut(sharedInstanceKey, timerQueue);
            }
            return timerQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startIfNeeded() {
        if (!this.running) {
            this.runningLock.lock();
            try {
                final ThreadGroup threadGroup = AppContext.getAppContext().getThreadGroup();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Thread thread = new Thread(threadGroup, TimerQueue.this, "TimerQueue");
                        thread.setDaemon(true);
                        thread.setPriority(5);
                        thread.start();
                        return null;
                    }
                });
                this.running = true;
            }
            finally {
                this.runningLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTimer(Timer timer, long l) {
        timer.getLock().lock();
        try {
            if (!this.containsTimer(timer)) {
                this.addTimer(new DelayedTimer(timer, TimeUnit.MILLISECONDS.toNanos(l) + TimerQueue.now()));
            }
        }
        finally {
            timer.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimer(DelayedTimer delayedTimer) {
        assert (delayedTimer != null && !this.containsTimer(delayedTimer.getTimer()));
        Timer timer = delayedTimer.getTimer();
        timer.getLock().lock();
        try {
            timer.delayedTimer = delayedTimer;
            this.queue.add(delayedTimer);
        }
        finally {
            timer.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimer(Timer timer) {
        timer.getLock().lock();
        try {
            if (timer.delayedTimer != null) {
                this.queue.remove(timer.delayedTimer);
                timer.delayedTimer = null;
            }
        }
        finally {
            timer.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsTimer(Timer timer) {
        timer.getLock().lock();
        try {
            boolean bl = timer.delayedTimer != null;
            return bl;
        }
        finally {
            timer.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block17: {
            this.runningLock.lock();
            block12: while (true) {
                try {
                    while (this.running) {
                        try {
                            Timer timer = ((DelayedTimer)this.queue.take()).getTimer();
                            timer.getLock().lock();
                            try {
                                DelayedTimer delayedTimer = timer.delayedTimer;
                                if (delayedTimer != null) {
                                    timer.post();
                                    timer.delayedTimer = null;
                                    if (timer.isRepeats()) {
                                        delayedTimer.setTime(TimerQueue.now() + TimeUnit.MILLISECONDS.toNanos(timer.getDelay()));
                                        this.addTimer(delayedTimer);
                                    }
                                }
                                timer.getLock().newCondition().awaitNanos(1L);
                            }
                            catch (SecurityException securityException) {}
                            continue block12;
                            finally {
                                timer.getLock().unlock();
                                continue block12;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (!AppContext.getAppContext().isDisposed()) continue;
                            break block17;
                        }
                    }
                    break block17;
                }
                catch (ThreadDeath threadDeath) {
                    for (DelayedTimer delayedTimer : this.queue) {
                        delayedTimer.getTimer().cancelEvent();
                    }
                    throw threadDeath;
                }
            }
            finally {
                this.running = false;
                this.runningLock.unlock();
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TimerQueue (");
        boolean bl = true;
        for (DelayedTimer delayedTimer : this.queue) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(delayedTimer.getTimer().toString());
            bl = false;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    static class DelayedTimer
    implements Delayed {
        private static final AtomicLong sequencer = new AtomicLong(0L);
        private final long sequenceNumber;
        private volatile long time;
        private final Timer timer;

        DelayedTimer(Timer timer, long l) {
            this.timer = timer;
            this.time = l;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public final long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.time - TimerQueue.now(), TimeUnit.NANOSECONDS);
        }

        final void setTime(long l) {
            this.time = l;
        }

        final Timer getTimer() {
            return this.timer;
        }

        @Override
        public int compareTo(Delayed delayed) {
            if (delayed == this) {
                return 0;
            }
            if (delayed instanceof DelayedTimer) {
                DelayedTimer delayedTimer = (DelayedTimer)delayed;
                long l = this.time - delayedTimer.time;
                if (l < 0L) {
                    return -1;
                }
                if (l > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < delayedTimer.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long l = this.getDelay(TimeUnit.NANOSECONDS) - delayed.getDelay(TimeUnit.NANOSECONDS);
            return l == 0L ? 0 : (l < 0L ? -1 : 1);
        }
    }
}

