/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import sun.misc.FloatConsts;

public class FpUtils {
    static double twoToTheDoubleScaleUp = FpUtils.powerOfTwoD(512);
    static double twoToTheDoubleScaleDown = FpUtils.powerOfTwoD(-512);

    private FpUtils() {
    }

    public static int getExponent(double d) {
        return (int)(((Double.doubleToRawLongBits(d) & 0x7FF0000000000000L) >> 52) - 1023L);
    }

    public static int getExponent(float f) {
        return ((Float.floatToRawIntBits(f) & 0x7F800000) >> 23) - 127;
    }

    static double powerOfTwoD(int n) {
        assert (n >= -1022 && n <= 1023);
        return Double.longBitsToDouble((long)n + 1023L << 52 & 0x7FF0000000000000L);
    }

    static float powerOfTwoF(int n) {
        assert (n >= -126 && n <= 127);
        return Float.intBitsToFloat(n + 127 << 23 & 0x7F800000);
    }

    public static double rawCopySign(double d, double d2) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & Long.MIN_VALUE | Double.doubleToRawLongBits(d) & Long.MAX_VALUE);
    }

    public static float rawCopySign(float f, float f2) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(f2) & Integer.MIN_VALUE | Float.floatToRawIntBits(f) & Integer.MAX_VALUE);
    }

    public static boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }

    public static boolean isFinite(float f) {
        return Math.abs(f) <= Float.MAX_VALUE;
    }

    public static boolean isInfinite(double d) {
        return Double.isInfinite(d);
    }

    public static boolean isInfinite(float f) {
        return Float.isInfinite(f);
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static boolean isNaN(float f) {
        return Float.isNaN(f);
    }

    public static boolean isUnordered(double d, double d2) {
        return FpUtils.isNaN(d) || FpUtils.isNaN(d2);
    }

    public static boolean isUnordered(float f, float f2) {
        return FpUtils.isNaN(f) || FpUtils.isNaN(f2);
    }

    public static int ilogb(double d) {
        int n = FpUtils.getExponent(d);
        switch (n) {
            case 1024: {
                if (FpUtils.isNaN(d)) {
                    return 0x40000000;
                }
                return 0x10000000;
            }
            case -1023: {
                if (d == 0.0) {
                    return -268435456;
                }
                long l = Double.doubleToRawLongBits(d);
                assert ((l &= 0xFFFFFFFFFFFFFL) != 0L);
                while (l < 0x10000000000000L) {
                    l *= 2L;
                    --n;
                }
                assert (++n >= -1074 && n < -1022);
                return n;
            }
        }
        assert (n >= -1022 && n <= 1023);
        return n;
    }

    public static int ilogb(float f) {
        int n = FpUtils.getExponent(f);
        switch (n) {
            case 128: {
                if (FpUtils.isNaN(f)) {
                    return 0x40000000;
                }
                return 0x10000000;
            }
            case -127: {
                if (f == 0.0f) {
                    return -268435456;
                }
                int n2 = Float.floatToRawIntBits(f);
                assert ((n2 &= 0x7FFFFF) != 0);
                while (n2 < 0x800000) {
                    n2 *= 2;
                    --n;
                }
                assert (++n >= -149 && n < -126);
                return n;
            }
        }
        assert (n >= -126 && n <= 127);
        return n;
    }

    public static double scalb(double d, int n) {
        int n2 = 0;
        int n3 = 0;
        double d2 = Double.NaN;
        if (n < 0) {
            n = Math.max(n, -2099);
            n3 = -512;
            d2 = twoToTheDoubleScaleDown;
        } else {
            n = Math.min(n, 2099);
            n3 = 512;
            d2 = twoToTheDoubleScaleUp;
        }
        int n4 = n >> 8 >>> 23;
        n2 = (n + n4 & 0x1FF) - n4;
        d *= FpUtils.powerOfTwoD(n2);
        n -= n2;
        while (n != 0) {
            d *= d2;
            n -= n3;
        }
        return d;
    }

    public static float scalb(float f, int n) {
        n = Math.max(Math.min(n, 278), -278);
        return (float)((double)f * FpUtils.powerOfTwoD(n));
    }

    public static double nextAfter(double d, double d2) {
        if (FpUtils.isNaN(d) || FpUtils.isNaN(d2)) {
            return d + d2;
        }
        if (d == d2) {
            return d2;
        }
        long l = Double.doubleToRawLongBits(d + 0.0);
        if (d2 > d) {
            l += l >= 0L ? 1L : -1L;
        } else {
            assert (d2 < d);
            l = l > 0L ? --l : (l < 0L ? ++l : -9223372036854775807L);
        }
        return Double.longBitsToDouble(l);
    }

    public static float nextAfter(float f, double d) {
        if (FpUtils.isNaN(f) || FpUtils.isNaN(d)) {
            return f + (float)d;
        }
        if ((double)f == d) {
            return (float)d;
        }
        int n = Float.floatToRawIntBits(f + 0.0f);
        if (d > (double)f) {
            n += n >= 0 ? 1 : -1;
        } else {
            assert (d < (double)f);
            n = n > 0 ? --n : (n < 0 ? ++n : -2147483647);
        }
        return Float.intBitsToFloat(n);
    }

    public static double nextUp(double d) {
        if (FpUtils.isNaN(d) || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d += 0.0) + (d >= 0.0 ? 1L : -1L));
    }

    public static float nextUp(float f) {
        if (FpUtils.isNaN(f) || f == Float.POSITIVE_INFINITY) {
            return f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f += 0.0f) + (f >= 0.0f ? 1 : -1));
    }

    public static double nextDown(double d) {
        if (FpUtils.isNaN(d) || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d == 0.0) {
            return -Double.MIN_VALUE;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) + (d > 0.0 ? -1L : 1L));
    }

    public static double nextDown(float f) {
        if (FpUtils.isNaN(f) || f == Float.NEGATIVE_INFINITY) {
            return f;
        }
        if (f == 0.0f) {
            return -Float.MIN_VALUE;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f) + (f > 0.0f ? -1 : 1));
    }

    public static double copySign(double d, double d2) {
        return FpUtils.rawCopySign(d, FpUtils.isNaN(d2) ? 1.0 : d2);
    }

    public static float copySign(float f, float f2) {
        return FpUtils.rawCopySign(f, FpUtils.isNaN(f2) ? 1.0f : f2);
    }

    public static double ulp(double d) {
        int n = FpUtils.getExponent(d);
        switch (n) {
            case 1024: {
                return Math.abs(d);
            }
            case -1023: {
                return Double.MIN_VALUE;
            }
        }
        assert (n <= 1023 && n >= -1022);
        if ((n -= 52) >= -1022) {
            return FpUtils.powerOfTwoD(n);
        }
        return Double.longBitsToDouble(1L << n - -1074);
    }

    public static float ulp(float f) {
        int n = FpUtils.getExponent(f);
        switch (n) {
            case 128: {
                return Math.abs(f);
            }
            case -127: {
                return FloatConsts.MIN_VALUE;
            }
        }
        assert (n <= 127 && n >= -126);
        if ((n -= 23) >= -126) {
            return FpUtils.powerOfTwoF(n);
        }
        return Float.intBitsToFloat(1 << n - -149);
    }

    public static double signum(double d) {
        return d == 0.0 || FpUtils.isNaN(d) ? d : FpUtils.copySign(1.0, d);
    }

    public static float signum(float f) {
        return f == 0.0f || FpUtils.isNaN(f) ? f : FpUtils.copySign(1.0f, f);
    }
}

