/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.PeerAddressChangeNotification;
import java.net.SocketAddress;
import sun.nio.ch.SctpNotification;

public class SctpPeerAddrChange
extends PeerAddressChangeNotification
implements SctpNotification {
    private static final int SCTP_ADDR_AVAILABLE = 1;
    private static final int SCTP_ADDR_UNREACHABLE = 2;
    private static final int SCTP_ADDR_REMOVED = 3;
    private static final int SCTP_ADDR_ADDED = 4;
    private static final int SCTP_ADDR_MADE_PRIM = 5;
    private static final int SCTP_ADDR_CONFIRMED = 6;
    private Association association;
    private int assocId;
    private SocketAddress address;
    private PeerAddressChangeNotification.AddressChangeEvent event;

    private SctpPeerAddrChange(int n, SocketAddress socketAddress, int n2) {
        switch (n2) {
            case 1: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_AVAILABLE;
                break;
            }
            case 2: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_UNREACHABLE;
                break;
            }
            case 3: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_REMOVED;
                break;
            }
            case 4: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_ADDED;
                break;
            }
            case 5: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_MADE_PRIMARY;
                break;
            }
            case 6: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_CONFIRMED;
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown event type");
            }
        }
        this.assocId = n;
        this.address = socketAddress;
    }

    @Override
    public int assocId() {
        return this.assocId;
    }

    @Override
    public void setAssociation(Association association) {
        this.association = association;
    }

    @Override
    public SocketAddress address() {
        assert (this.address != null);
        return this.address;
    }

    @Override
    public Association association() {
        assert (this.association != null);
        return this.association;
    }

    @Override
    public PeerAddressChangeNotification.AddressChangeEvent event() {
        assert (this.event != null);
        return this.event;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append(" [");
        stringBuilder.append("Address: ").append(this.address);
        stringBuilder.append(", Association:").append(this.association);
        stringBuilder.append(", Event: ").append((Object)this.event).append("]");
        return stringBuilder.toString();
    }
}

