/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.asm.sparc.SPARCV9InstructionFactory;
import sun.jvm.hotspot.asm.sparc.V9CMoveDecoder;

class V9MOVccDecoder
extends V9CMoveDecoder {
    V9MOVccDecoder() {
    }

    private static String getMoveCCName(int conditionCode, int conditionFlag) {
        return "mov" + V9MOVccDecoder.getConditionName(conditionCode, conditionFlag);
    }

    private static int getMoveConditionFlag(int instruction) {
        boolean cc2Bit = (instruction & 0x40000) != 0;
        int conditionFlag = (instruction & 0x1800) >>> 11;
        if (cc2Bit) {
            conditionFlag |= 4;
        }
        return conditionFlag;
    }

    @Override
    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        SPARCV9InstructionFactory v9factory = (SPARCV9InstructionFactory)factory;
        SPARCInstruction instr = null;
        int conditionFlag = V9MOVccDecoder.getMoveConditionFlag(instruction);
        if (conditionFlag == 5 || conditionFlag == 7) {
            instr = v9factory.newIllegalInstruction(instruction);
        } else {
            int rdNum = V9MOVccDecoder.getDestinationRegister(instruction);
            SPARCRegister rd = SPARCRegisters.getRegister(rdNum);
            int conditionCode = V9MOVccDecoder.getMoveConditionCode(instruction);
            ImmediateOrRegister source = V9MOVccDecoder.getCMoveSource(instruction, 11);
            String name = V9MOVccDecoder.getMoveCCName(conditionCode, conditionFlag);
            instr = v9factory.newV9MOVccInstruction(name, conditionCode, conditionFlag, source, rd);
        }
        return instr;
    }
}

