"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tracingToggled = tracingToggled;
exports.clearTracerData = clearTracerData;
exports.addTraces = addTraces;
exports.selectTrace = selectTrace;
exports.setLocalAndRemoteRuntimeVersion = setLocalAndRemoteRuntimeVersion;
loader.lazyRequireGetter(this, "_index", "devtools/client/debugger/src/selectors/index");
loader.lazyRequireGetter(this, "_select", "devtools/client/debugger/src/actions/sources/select.js");

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at <http://mozilla.org/MPL/2.0/>. */
const {
  TRACER_FIELDS_INDEXES
} = require("resource://devtools/server/actors/tracer.js");
/**
 * Called when tracing is toggled ON/OFF on a particular thread.
 */


function tracingToggled(thread, enabled) {
  return {
    type: "TRACING_TOGGLED",
    thread,
    enabled
  };
}

function clearTracerData() {
  return {
    type: "TRACING_CLEAR"
  };
}

function addTraces(traces) {
  return async function ({
    dispatch,
    getState
  }) {
    if (!(0, _index.getIsCurrentlyTracing)(getState())) {
      return null;
    }

    return dispatch({
      type: "ADD_TRACES",
      traces
    });
  };
}

function selectTrace(traceIndex) {
  return async function ({
    dispatch,
    getState
  }) {
    // For now, the tracer only consider the top level thread
    const thread = (0, _index.getCurrentThread)(getState());
    dispatch({
      type: "SELECT_TRACE",
      traceIndex,
      thread
    });
    const traces = (0, _index.getAllTraces)(getState());
    const trace = traces[traceIndex]; // Ignore DOM Event traces, which aren't related to a particular location in source.

    if (!trace || trace[TRACER_FIELDS_INDEXES.TYPE] == "event") {
      return;
    }

    const frameIndex = trace[TRACER_FIELDS_INDEXES.FRAME_INDEX];
    const frames = (0, _index.getTraceFrames)(getState());
    const frame = frames[frameIndex];
    await dispatch((0, _select.selectSourceBySourceActorID)(frame.sourceId, {
      line: frame.line,
      column: frame.column
    }));
  };
}

function setLocalAndRemoteRuntimeVersion(localPlatformVersion, remotePlatformVersion) {
  return {
    type: "SET_RUNTIME_VERSIONS",
    localPlatformVersion,
    remotePlatformVersion
  };
}