/* Copyright (c) 1991 by John Atwood deVries II. */
/* $Id: server.h,v 1.10 2000/03/23 14:41:52 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

#include "protocol.h"
#include "config.h"

#define IDLE_POLLWAIT   30000   /* polltimeout (msecs) when users = 0 */
#define BUSY_POLLWAIT   10000   /* polltimeout (msecs) when users >= 1 */
#define POLL_DELAY      1000    /* min wait through each poll */

/*
   BEWARE!! of the relationship between MAX_REAL_USERS and the various
   resident automagical users -- esp. for fencepost errors.
*/
#define	MAX_REAL_USERS (MAX_USERS - 1)
#define	NICKSERV (MAX_USERS - 1)

/* a linked list of strings */

typedef struct Strlist {
	struct Strlist *next, *prev;
	char str[1];
} STRLIST;

/* manages a name list */
typedef struct Namlist {
	STRLIST *head, *tail;       /* head and tail of name list */
	STRLIST *p;	/* user current location in name list */
	int num;	/* current number of name list entries */
	int max;	/* max number of list entries before discard */
} NAMLIST;

typedef struct {
        char loginid [MAX_IDLEN+1];  /* their loginid */
        char nodeid [MAX_NODELEN+1];  /* the id of their client's machine */
        char nickname [MAX_NICKLEN+1];  /* their nickname */
        char password [MAX_PASSWDLEN+1];  /* their password */
        char realname [MAX_REALLEN+1];  /* their real name */
        char group[MAX_GROUPLEN+1];  /* name of which group they are in */
        int login;  /* have they sent a login message yet */
	int echoback; /* do they have echoback on or off? */
	int nobeep;	/* do they have nobeep on or off? */
	int t_notify;   /* Have they been timeout notified? */
	long t_on;	/* when signed on, */
	long t_sent;	/* last time we sent them something */
	long t_recv;	/* last time they sent us something -- */
	long t_group;   /* last time they changed groups */
			/* all time stuff */
	NAMLIST * pri_n_hushed;
	NAMLIST * pub_n_hushed;
	NAMLIST * pri_s_hushed;
	NAMLIST * pub_s_hushed;
	NAMLIST * n_notifies;
	NAMLIST * s_notifies;
} USER_ITEM;

typedef struct {
	char name [MAX_GROUPLEN+1];  /* the name of the group */
				   /* if inactive, then NULL */
	char topic [MAX_TOPICLEN+1];  /* the topic of that group */
				    /* if inactive, then NULL */
	int visibility; /* NORMAL, SECRET, SUPERSECRET */
	int control; /* PUBLIC, MODERATED, RESTRICTED, CONTROLLED */
	int volume; /* quiet, normal, loud */
	int mod; /* index of who is moderator (if any) */
			       /* if none, then -1 */
	char missingmod [MAX_NICKLEN+1]; /* the timed out moderator */
	long modtimeout;	/* moderator timeout */
	NAMLIST * n_invites;
	NAMLIST * nr_invites;
	NAMLIST * s_invites;
	NAMLIST * sr_invites;
	NAMLIST * n_bars;
	NAMLIST * n_nr_bars;
	NAMLIST * s_bars;
	NAMLIST * s_nr_bars;
	NAMLIST * n_talk;
	NAMLIST * nr_talk;
	/*
	   next group  (if it was a linked list instead of a table)
	*/
} GROUP_ITEM;
