/* Copyright (c) 1988 Carrick Sean Casey. All rights reserved. */
/* $Id$ */

/* send a packet along a socket file descriptor */

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include "externs.h"

int	sendpacket(int, char *);

int
sendpacket(int s, char *pkt)
{
	int sent, ret = 1, fcarg;
	int totlength;

	/* set up a sample packet for testing purposes */
	totlength = (unsigned char)*pkt + 1;

        /* make the socket non-blocking */
        if (((fcarg = fcntl(s, F_GETFL, 0)) < 0 ||
            fcntl(s, F_SETFL, fcarg | O_NONBLOCK) < 0)) {
                perror("sendpacket:fcntl");
                return(-1);
        } 

	if ((sent = send(s, pkt, totlength, 0)) < 0) {
		if (errno == EWOULDBLOCK)
			ret = 0;
		else if (errno == EPIPE)
			ret = -1;
		else {
			/* DEBUG temorary fix */
			ret = -2;
		}
	} else {
		if(sent != totlength)
			ret = -1;
	}

	if (fcntl(s, F_SETFL, fcarg & ~O_NONBLOCK) < 0) {
		perror("sendpacket:fcntl");
	  	ret = -1;
	}

	return(ret);
}
