/* Copyright 1991 by John Atwood deVries II. */
/* $Id: s_motd.c,v 1.31 2001/10/29 18:05:43 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* primitive to print the motd */

#include <sys/types.h>
#include <db.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include "externs.h"
#include "userdb.h"

void	s_motd (int, int);

/*ARGSUSED*/
void
s_motd(int n, int argc)
{
	int motd_fd;
	char c;
	DBT key, data;
	char line[LINE_SIZE];
	int i;

	motd_fd = open(ICBDMOTD, O_RDONLY);

	line[0] = '\0';

	/* if the file is there, list it, otherwise report error */
	if (motd_fd >= 0) {
		while ((i = read(motd_fd, &c, 1)) > 0) {
			if (c == '%') {
				i = read(motd_fd, &c, 1);
				if (i <= 0) {
					if (close(motd_fd) != 0) {
						error("MOTD File Close: %s", strerror(errno));
					}
					break;
				} else if (c == 'U') {
					if (userdb) {
						key.data="server.signon";
						key.size=strlen(key.data);
						if (!userdb->get(userdb, &key, &data, 0)) {
							int l;

							l = strlen(line) + data.size;
							if ( l < LINE_SIZE)  {
								strncat(line, data.data, data.size);
								line[l] = '\0';
							} else
								error ("%U expansion does not fit in line");
						}
					}
				} else {
					int l;

					l = strlen(line);
					line[l] = c;
					line[l+1] = '\0';
				}
			} else if (c == '\012') {
				sends_cmdout(n, line);
				line[0] = '\0';
			} else {
				int l;

				l = strlen(line);
				line[l] = c;
				line[l+1] = '\0';
			}
		}
		if (close(motd_fd) != 0)
			error("MOTD File Close: %s", strerror(errno));
	} else
		error("MOTD File Open: %s", strerror(errno));
}
