/* Copyright 1991 by John Atwood deVries II. */
/* For copying and distribution information, see the file COPYING. */
/* $Id: errors.c,v 1.16.4.1 2003/10/24 20:50:41 jwise Exp $ */

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include "externs.h"

void	mdb (char *);
void	debugx (char *s, ...);
void	error (const char *s, ...);
void	info (char *s, ...);

void
mdb (char *s)
{
	char	timebuf[LINE_SIZE];
	char	tbuf[512];
	time_t	curtime;
	
	time(&curtime);
	strftime(timebuf, LINE_SIZE, "%b %d %Y %H:%M:%S", localtime(&curtime));
        snprintf(tbuf, 512, "%s %s: icbd: %s \n", timebuf, thishost, s);
	write(icbd_log, tbuf, strlen(tbuf));
}

void
debugx (char *s, ...)
{
#ifdef DEBUG
	char buf[LINE_SIZE] = "[DEBUG] ";
	va_list ap;

	va_start(ap, s);
	vsnprintf(buf + 8, LINE_SIZE - 8, s, ap);
	mdb(buf);
	va_end(ap);
#endif
}

void
error (const char *s, ...)
{
	char buf[LINE_SIZE] = "[ERROR] ";
	va_list ap;

	va_start(ap, s);
	vsnprintf(buf + 8, LINE_SIZE - 8, s, ap);
	mdb(buf);
	va_end(ap);
}

void
info (char *s, ...)
{
	char buf[LINE_SIZE] = "[INFO] ";
	va_list ap;

	va_start(ap, s);
	vsnprintf(buf + 7, LINE_SIZE - 7, s, ap);
	mdb(buf);
	va_end(ap);
}
