/* Copyright (c) 1988 by Carrick Sean Casey. All rights reserved. */
/* $Id: discuser.c,v 1.9 2000/03/23 14:41:44 jwise Exp $ */

/* shutdown a connection and take it out of the input loop */

#include <sys/types.h>
#include <unistd.h>
#include "externs.h"

void	disconnectuser (int);

void
disconnectuser(int user)
{
	int i;

	close(user);
	FD_CLR(user,&fdset);
	if (user == highestfd) {
		for (i = FD_SETSIZE-1; i > 0 && !FD_ISSET(i, &fdset); i--);
		highestfd = i;
	}
	/* let main program know user went bye bye */
	s_lost_user(user);
}
