/* Copyright (c) 1990 by Carrick Sean Casey. */
/* For copying and distribution information, see the file COPYING. */

/* signal handling routines */

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <readline/readline.h>
#include "icb.h"
#include "externs.h"

void	trapsignals (void);
void	suspend (int n);
void	askquit (int n);

/* Note that some of these routines set "continue" to 1. Continue is used */
/* by a few other icb routines to see if they've been interrupted */

/* The signal stuff is not portable, and should be in unix.c. */

#define	mask(s)	(1 << ((s)-1))

/* set up the signal trappers */

void
trapsignals (void)
{
	/* exit on a hangup or terminate signal */
	signal(SIGHUP, icbexit);
	signal(SIGTERM, icbexit);

	/* on an interrupt, verify the user wants to quit */
	signal(SIGINT, askquit);

	/* suspend on a stop signal */
	signal(SIGTSTP, suspend);
}


/* handle a stop signal */
/* this technique is something I learned from some other software */
/* someday I need to learn just why it works */

void
suspend (int n)
{
	restoreterm();
	signal(SIGTSTP, SIG_DFL);
	sigsetmask(sigblock(0) &~ mask(SIGTSTP));
	kill(0, SIGTSTP);
	sigblock(mask(SIGTSTP));
	signal(SIGTSTP, suspend);
	icbterm();
	continued = 1;
}


/* verify that the user wants to quit */

void
askquit (int n)
{
	int c;
	int oem;
	static char out[3] = { '\0', '\r', '\n' };

	signal(SIGINT, SIG_IGN);
	write(1, "\nReally Quit? ", 14);
	
	oem = echomode;
	noecho();
	if ((c = getchar()) == EOF)
		icbexit(0);
	
	out[0] = c;
	write(1, out, 3);
	if (c == 'Y' || c == 'y')
		icbexit(0);
	
	signal(SIGINT, askquit);
	continued = 1;

	if (oem)
	{
		rl_redisplay();
		echo();
	}
}
