#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>
#include <readline/readline.h>
#include "icb.h"
#include "externs.h"

void	readlineinit (void);

/*
 * readlineinit - set up for readline()
 */

void
readlineinit (void)
{
char *editor;

/*
 * bind the tab key
 */

rl_bind_key_in_map('\t', (Function *)handletab, vi_insertion_keymap);
rl_bind_key_in_map('\t', (Function *)handletab, vi_movement_keymap);
rl_bind_key_in_map('\t', (Function *)handletab, emacs_standard_keymap);

rl_vi_editing_mode(0, ' '); /* default to vi, dammit. */
gv.editmode = "vi";

editor = (char *)getenv("EDITOR");
if (!editor)
	editor = (char *)getenv("VISUAL");

if (editor != NULL)
   if (strcmp((char *)basename(editor),"emacs")==0)
   {
	rl_emacs_editing_mode(0, ' ');
	gv.editmode = "emacs";
   }

}
