C
C     THIS DRIVER TESTS  EISPACK  FOR THE CLASS OF REAL SYMMETRIC TRI-
C     DIAGONAL MATRICES SUMMARIZING THE FIGURES OF MERIT FOR ALL PATHS.
C
C     THIS DRIVER IS CATALOGUED AS  EISPDRV4(RSTSUMAR).
C
C     THE DIMENSION OF  ST  SHOULD BE  NM  BY  2.
C     THE DIMENSION OF  Z  SHOULD BE  NM  BY  NM.
C     THE DIMENSION OF  W,E,E2,IND,RV1,RV2,RV3,RV4,RV5,RV6,
C     W1,  AND  W2  SHOULD BE  NM.
C     THE DIMENSION OF  STHOLD  SHOULD BE  NM  BY  2.
C     HERE NM = 20.
C
      REAL Z(20,20),ST(20,2),STHOLD(20,2),W(20),E(20),
     X        E2(20),RV1(20),RV2(20),RV3(20),RV4(20),RV5(20),RV6(20),
     X        W1( 20),W2( 20),TCRIT( 8),EPSLON,RESDUL,MAXEIG,MAXDIF,
     X        U,LB,UB,EPS1,DFL
      REAL  XUB,XLB
      INTEGER IND( 20),IERR( 6),ERROR
      DATA IREAD1/1/,IREADC/5/,IWRITE/6/
C
      OPEN(UNIT=IREAD1,FILE='FILE51')
      OPEN(UNIT=IREADC,FILE='FILE52')
      REWIND IREAD1
      REWIND IREADC
C
      NM = 20
      MMB = 2
      LCOUNT = 0
      WRITE(IWRITE,1)
    1 FORMAT(1H1,19X,57H EXPLANATION OF COLUMN ENTRIES FOR THE SUMMARY S
     XTATISTICS//1H ,95(1H-)/96H ORDER TQL2   TQL1   IMTQL2 IMTQL1    LB
     X      UB    M  IMTQLV   TSTURM   BISECT  M1 NO   RATQR  /1H ,
     X95(1H-)//48H UNDER 'ORDER' IS THE ORDER OF EACH TEST MATRIX. //
     X95H UNDER 'TQL2   TQL1' ARE THREE NUMBERS.  THE FIRST NUMBER, AN I
     XNTEGER, IS THE ABSOLUTE SUM OF  /
     X95H THE ERROR FLAGS RETURNED SEPARATELY FROM  TQL2  AND  TQL1.  TH
     XE SECOND NUMBER IS THE MEASURE  /
     X62H OF PERFORMANCE BASED UPON THE RESIDUAL COMPUTED FOR THE  TQL2,
     X25H  PATH.  THE THIRD NUMBER        /
     X62H MEASURES THE AGREEMENT OF THE EIGENVALUES FROM THE  TQL2  AND,
     X14H  TQL1  PATHS.    //
     X95H UNDER 'IMTQL2 IMTQL1' ARE THREE NUMBERS WITH MEANING LIKE THOS
     XE UNDER  'TQL2   TQL1'.         //
     X95H UNDER 'LB' AND 'UB' ARE THE INPUT VARIABLES SPECIFYING THE INT
     XERVAL TO  BISECT  AND  TSTURM.  //
     X61H UNDER 'M' IS THE NUMBER OF EIGENVALUES DETERMINED BY  BISECT,
     X30H  AND  TSTURM  THAT LIE IN THE    /18H INTERVAL (LB,UB).//
     X95H UNDER EACH OF 'IMTQLV', 'TSTURM', 'BISECT', AND 'RATQR' ARE TW
     XO NUMBERS.  THE FIRST NUMBER,       )
      WRITE(IWRITE,2)
    2 FORMAT(
     X95H AN INTEGER, IS THE ABSOLUTE SUM OF THE ERROR FLAGS RETURNED FR
     XOM THE RESPECTIVE PATH.         /
     X95H THE SECOND NUMBER IS THE MEASURE OF PERFORMANCE BASED UPON THE
     X RESIDUAL COMPUTED FOR THE PATH.//
     X95H UNDER 'M1' AND 'NO' ARE THE VARIABLES SPECIFYING THE LOWER BOU
     XNDARY INDEX AND THE NUMBER       /
     X28H OF EIGENVALUES TO  RATQR.  //
     X62H -1.0  AS THE MEASURE OF PERFORMANCE IS PRINTED IF AN ERROR IN,
     X27H THE CORRESPONDING PATH HAS        /
     X47H PREVENTED THE COMPUTATION OF THE EIGENVECTORS. //
     X62H THE  TQL2    PATH USES THE EISPACK CODES  TQL2  .            /
     X62H THE  TQL1    PATH USES THE EISPACK CODES  TQL1  .            /
     X62H THE  IMTQL2  PATH USES THE EISPACK CODES  IMTQL2,            /
     X39H AS CALLED FROM DRIVER SUBROUTINE  RST. /
     X62H THE  IMTQL1  PATH USES THE EISPACK CODES  IMTQL1,            /
     X39H AS CALLED FROM DRIVER SUBROUTINE  RST. /
     X57H THE  IMTQLV  PATH USES THE EISPACK CODES  IMTQLV-TINVIT.
     X            )
      WRITE(IWRITE,3)
    3 FORMAT(
     X50H THE  TSTURM  PATH USES THE EISPACK CODES  TSTURM.
     X   /
     X57H THE  BISECT  PATH USES THE EISPACK CODES  BISECT-TINVIT.
     X             /
     X57H THE  RATQR   PATH USES THE EISPACK CODES  RATQR -TINVIT.
     X             /)
      WRITE(IWRITE,15)
   15 FORMAT(1X,21HS.P. VERSION 04/15/83 )
    5 FORMAT( 53H1       TABULATION OF THE ERROR FLAG  ERROR  AND THE ,
     X    31HMEASURE OF PERFORMANCE  Y  FOR /5X,
     X    56HTHE  EISPACK  CODES.  THIS RUN DISPLAYS THESE STATISTICS ,
     X    41H FOR REAL SYMMETRIC TRIDIAGONAL MATRICES.  /
     X    55H0ORDER TQL2   TQL1   IMTQL2 IMTQL1    LB      UB    M   ,
     X    40HIMTQLV   TSTURM   BISECT  M1 NO   RATQR )
   10 CALL RMATIN(NM,MMB,N,MB,ST,STHOLD,0)
      READ(IREADC,50) MM,LB,UB,M11,NO
   50 FORMAT(I4,2D24.16,2(4X,I4))
C
C     MM,LB,UB,M11,  AND  NO  ARE READ FROM SYSIN AFTER THE MATRIX IS
C     GENERATED.  MM,LB,  AND  UB  SPECIFY TO  BISECT  THE MAXIMUM
C     NUMBER OF EIGENVALUES AND BOUNDS FOR THE INTERVAL WHICH IS TO
C     BE SEARCHED.  M11  AND  NO  SPECIFY TO  RATQR  THE LOWER BOUNDARY
C     INDEX AND THE NUMBER OF DESIRED EIGENVALUES.
C
      DO  230  ICALL = 1,10
         IF( ICALL .NE. 1 )  CALL  RMATIN(NM,MMB,N,MB,ST,STHOLD,1)
C
C
C     IF  TQL1  PATH (LABEL 80) IS TAKEN THEN  TQL2  PATH (LABEL 70)
C     MUST ALSO BE TAKEN IN ORDER THAT THE MEASURE OF PERFORMANCE BE
C     MEANINGFUL.
C     IF  IMTQL1  PATH (LABEL 85) IS TAKEN THEN  IMTQL2  PATH (LABEL 75)
C     MUST ALSO BE TAKEN IN ORDER THAT THE MEASURE OF PERFORMANCE BE
C     MEANINGFUL.
C     IF  TQL2  (IMTQL2)  PATH FAILS, THEN  TQL1  (IMTQL1)  PATH IS
C     OMITTED AND PRINTOUT FLAGGED WITH  -1.0.
C
         GO TO  (70,75,80,85,89,90,95,230,110,230),  ICALL
C
C     RSTWZ  USING  TQL2
C
   70    ICT = 1
         DO  72  I = 1,N
            DO  71  J = 1,N
   71         Z(I,J) = 0.0E0
            Z(I,I) = 1.0E0
            E(I) = ST(I,1)
   72       W(I) = ST(I,2)
         CALL  TQL2(NM,N,W,E,Z,ERROR)
         IERR(ICT) = ERROR
         M = ERROR - 1
         IF( ERROR .NE. 0 ) GO TO 190
         DO 73 I = 1,N
   73       W1(I) = W(I)
         M = N
         GO TO  190
C
C     RSTWZ  USING  IMTQL2
C     INVOKED FROM DRIVER SUBROUTINE  RST.
C
   75    ICT = 2
         DO  77  I = 1,N
            E(I) = ST(I,1)
   77       W(I) = ST(I,2)
         CALL  RST(NM,N,W,E,1,Z,ERROR)
         IERR(ICT) = ERROR
         M = ERROR - 1
         IF( ERROR .NE. 0 ) GO TO 190
         DO 78 I = 1,N
            W2(I) = W(I)
   78    CONTINUE
         M = N
         GO TO  190
C
C     RSTW  USING  TQL1
C
   80    ICT = 7
         IF( IERR(1) .NE. 0 ) GO TO 200
         DO  81  I = 1,N
   81       W(I) = ST(I,2)
         CALL  TQL1(N,W,ST(1,1),ERROR)
         IERR(1) = ERROR
         IF( ERROR .NE. 0 ) GO TO 200
         MAXEIG = 0.0E0
         MAXDIF = 0.0E0
         DO 82 I = 1,N
            IF( ABS(W(I)) .GT. MAXEIG ) MAXEIG = ABS(W(I))
            U = ABS(W1(I) - W(I))
            IF( U .GT. MAXDIF ) MAXDIF = U
   82    CONTINUE
         IF( MAXEIG .EQ. 0.0E0 ) MAXEIG = 1.0E0
         DFL = N * 10
         TCRIT(7) = MAXDIF/EPSLON(MAXEIG*DFL)
         GO TO  230
C
C     RSTW  USING  IMTQL1
C     INVOKED FROM DRIVER SUBROUTINE  RST.
C
   85    ICT = 8
         IF( IERR(2) .NE. 0 ) GO TO 200
         DO  86  I = 1,N
         E(I) = ST(I,1)
   86       W(I) = ST(I,2)
         CALL  RST(NM,N,W,E,0,Z,ERROR)
         IERR(2) = ERROR
         IF( ERROR .NE. 0 ) GO TO 200
         MAXEIG = 0.0E0
         MAXDIF = 0.0E0
         DO 87 I = 1,N
            IF( ABS(W(I)) .GT. MAXEIG ) MAXEIG = ABS(W(I))
            U = ABS(W2(I) - W(I))
            IF( U .GT. MAXDIF ) MAXDIF = U
   87    CONTINUE
         IF( MAXEIG .EQ. 0.0E0 ) MAXEIG = 1.0E0
         DFL = N * 10
         TCRIT(8) = MAXDIF/EPSLON(MAXEIG*DFL)
         GO TO  230
C
C     RSTW1Z  ( USAGE HERE COMPUTES ALL EIGENVECTORS )
C
   89    ICT = 3
         DO 891 I = 2,N
             E2(I) = ST(I,1) ** 2
  891    CONTINUE
         CALL IMTQLV(N,ST(1,2),ST(1,1),E2,W,IND,ERROR,RV1)
         IERR(ICT) = ERROR
         M = N
         IF( ERROR .NE. 0 ) M = ERROR - 1
  893    CALL TINVIT(NM,N,ST(1,2),ST(1,1),E2,M,W,IND,Z,ERROR,RV1,RV2,
     X               RV3,RV4,RV6)
         IERR(ICT) = IERR(ICT) + IABS(ERROR)
         GO TO 190
C
C     RST1W1Z  USING  TSTURM
C
   90    ICT = 4
         EPS1 = 0.0E0
         DO  92  I = 2,N
   92       E2(I) = ST(I,1)**2
         CALL  TSTURM(NM,N,EPS1,ST(1,2),ST(1,1),E2,LB,UB,MM,M,W,Z,
     X                ERROR,RV1,RV2,RV3,RV4,RV5,RV6)
         IERR(ICT) = ERROR
         XLB = LB
         XUB = UB
         IF( ERROR .EQ. 3*N + 1) GO TO 200
         IF( ERROR .GT. 4*N ) M = ERROR - 4*N - 1
         GO TO  190
C
C     RST1W1Z  USING  BISECT  AND  TINVIT
C
   95    ICT = 5
         EPS1 = 0.0E0
         DO  97  I = 2,N
   97       E2(I) = ST(I,1)**2
         CALL  BISECT(N,EPS1,ST(1,2),ST(1,1),E2,LB,UB,MM,M,W,IND,ERROR,
     X                RV4,RV5)
         IERR(ICT) = ERROR
         MBISCT = M
         XLB = LB
         XUB = UB
         IF( ERROR .NE. 0 ) GO TO 200
         CALL  TINVIT(NM,N,ST(1,2),ST(1,1),E2,M,W,IND,Z,
     X                ERROR,RV1,RV2,RV3,RV4,RV6)
         IERR(ICT) = IABS(ERROR)
         GO TO  190
C
C     RST1W1Z  USING  RATQR  AND  TINVIT
C
  110    ICT = 6
         EPS1 = 0.0E0
         DO 112  I = 2,N
  112       E2(I) = ST(I,1)**2
         CALL  RATQR(N,EPS1,ST(1,2),ST(1,1),E2,NO+M11-1,W,IND,
     X               RV1,.TRUE.,0,ERROR)
         DO 115 I = 1,NO
            M = I + M11 - 1
            W(I) = W(M)
            IND(I) = IND(M)
  115    CONTINUE
         IERR(ICT) = ERROR
         IF( ERROR .NE. 0 )  GO TO  200
         M = NO
         CALL  TINVIT(NM,N,ST(1,2),ST(1,1),E2,M,W,IND,Z,ERROR,
     X                   RV1,RV2,RV3,RV4,RV6)
         IERR(ICT) = IABS(ERROR)
C
  190    IF( M .EQ. 0 .AND. ERROR .NE. 0 ) GO TO 200
         CALL  RSBWZR(NM,N,M,2,ST,W,Z,RV1,RESDUL)
         DFL = N * 10
         TCRIT(ICT) = RESDUL/EPSLON(DFL)
         GO TO 230
  200    TCRIT(ICT) = -1.0E0
  230 CONTINUE
C
      IF( MOD(LCOUNT,35) .EQ. 0 ) WRITE(IWRITE,5)
      LCOUNT = LCOUNT + 1
      WRITE(IWRITE,240) N,IERR(1),TCRIT(1),TCRIT(7),IERR(2),TCRIT(2),
     X             TCRIT(8),XLB,XUB,MBISCT,(IERR(I),TCRIT(I),I=3,5),
     X             M11,NO,IERR(6),TCRIT(6)
  240 FORMAT(I4,2(I3,2F6.3),2(1PE8.0),I3,3(I3,0PF6.3),3I3,F6.3)
      GO TO  10
      END
      SUBROUTINE RSBWZR(NM,N,M,MB,A,W,Z,NORM,RESDUL)
C
      INTEGER  MB,MB1
      REAL NORM(M), W(M), A(NM,MB), Z(NM,M), NORMA, TNORM,
     X       S, SUM, SUMA, SUMZ, RESDUL
C
C     THIS SUBROUTINE FORMS THE 1-NORM OF THE RESIDUAL MATRIX
C     A*Z-Z*DIAG(W)  WHERE  A  IS A REAL SYMMETRIC BAND MATRIX,
C     W  IS A VECTOR WHICH CONTAINS  M  EIGENVALUES OF  A, AND  Z
C     IS AN ARRAY WHICH CONTAINS THE  M  CORRESPONDING EIGENVECTORS OF
C     A.  ALL NORMS APPEARING IN THE COMMENTS BELOW ARE 1-NORMS.
C
C     THIS SUBROUTINE IS CATALOGUED AS EISPDRV4(RSBWZR).
C
C     INPUT.
C
C        NM IS THE ROW DIMENSION OF TWO-DIMENSIONAL ARRAY PARAMETERS
C           AS DECLARED IN THE CALLING PROGRAM DIMENSION STATEMENT;
C
C        N IS THE ORDER OF THE MATRIX  A;
C
C        M IS THE NUMBERS OF EIGENVECTORS WHOSE RESIDUALS ARE DESIRED;
C
C        MB  IS THE BAND WIDTH OF THE INPUT MATRIX  A .  BAND WIDTH IS
C            DEFINED AS THE NUMBER OF ADJACENT DIAGONALS, INCLUDING THE
C            PRINCIPAL DIAGONAL, REQUIRED TO SPECIFY THE NON-ZERO
C            PORTION OF THE LOWER TRIANGLE OF THE MATRIX;
C
C        A(N,MB) IS AN ARRAY WHICH CONTAINS IN ITS COLUMNS THE
C           SUBDIAGONAL AND DIAGONAL OF THE SYMMETRIC BAND
C           MATRIX;
C
C        W(M) IS A VECTOR WHOSE FIRST  M  COMPONENTS CONTAIN EIGENVALUES
C           OF  A;
C
C        Z(NM,M) IS AN ARRAY WHOSE FIRST  M  COLUMNS CONTAIN THE
C           EIGENVECTORS OF  A  CORRESPONDING TO THE EIGENVALUES IN  W.
C
C     OUTPUT.
C
C        Z(NM,M) IS AN ARRAY WHICH CONTAINS THE NORMALIZED
C           APPROXIMATE EIGENVECTORS OF  A.  THE EIGENVECTORS
C           ARE NORMALIZED USING THE 1-NORM IN SUCH A WAY
C           THAT THE FIRST ELEMENT WHOSE MAGNITUDE IS LARGER
C           THAN THE NORM OF THE EIGENVECTOR DIVIDED BY  N  IS
C           POSITIVE;
C
C        NORM(M) IS AN ARRAY SUCH THAT FOR EACH  K
C           NORM(K) = !!A*Z(K)-Z(K)*W(K)!!/(!!A!!*!!Z(K)!!)
C           WHERE  Z(K)  IS THE K-TH EIGENVECTOR;
C
C        RESDUL IS THE REAL NUMBER
C           !!A*Z-Z*DIAG(W)!!/(!!A!!*!!Z!!).
C
C     ----------------------------------------------------------------
C
      RESDUL = 0.0E0
      IF( M .EQ. 0 ) RETURN
      NORMA = 0.0E0
C
      DO 40 I=1,N
         J=I
         SUMA = 0.0E0
         IF(I .EQ. 1) GO TO 20
         MB1 = MB-1
         LSTART = MAX0(1,MB+1-I)
C
         DO 10 L=LSTART,MB1
   10       SUMA = SUMA + ABS(A(I,L))
C
   20    LSTOP = MIN0(MB,N+1-J)
C
         DO 30 L=1,LSTOP
            L1 = MB + 1 - L
            SUMA = SUMA + ABS(A(J,L1))
   30       J = J+1
C
   40    NORMA = AMAX1(SUMA,NORMA)
C
      IF(NORMA .EQ. 0.0E0) NORMA = 1.0E0
C
      DO 120 I=1,M
         S = 0.0E0
         SUMZ = 0.0E0
C
         DO 80 L=1,N
            SUM = -W(I)*Z(L,I)
            SUMZ = SUMZ + ABS(Z(L,I))
            J = MAX0(0,L-MB)
            IF(L .EQ. 1) GO TO 60
            MB1 = MB-1
            KSTART = MAX0(1,MB+1-L)
C
            DO 50 K=KSTART,MB1
               J = J+1
   50          SUM = SUM + A(L,K)*Z(J,I)
C
   60       KSTOP = MIN0(MB,N+1-L)
C
            DO 70 K=1,KSTOP
               J = J+1
               K1 = MB + 1 - K
   70          SUM = SUM + A(J,K1)*Z(J,I)
C
   80       S = S + ABS(SUM)
C
         NORM(I) = SUMZ
         IF (SUMZ .EQ. 0.0E0) GO TO 120
C        ..........THIS LOOP WILL NEVER BE COMPLETED SINCE THERE
C                  WILL ALWAYS EXIST AN ELEMENT IN THE VECTOR Z(I)
C                  LARGER THAN !!Z(I)!!/N..........
         DO 90 L=1,N
            IF(ABS(Z(L,I)) .GE. NORM(I)/N) GO TO 100
   90       CONTINUE
C
  100    TNORM = SIGN(NORM(I),Z(L,I))
C
         DO 110 L=1,N
  110       Z(L,I) = Z(L,I)/TNORM
C
         NORM(I) = S/(NORM(I)*NORMA)
  120    RESDUL = AMAX1(NORM(I),RESDUL)
C
      RETURN
      END
      SUBROUTINE RMATIN(NM,MMB,N,MB,ST,STHOLD,INITIL)
C
C     THIS INPUT SUBROUTINE READS A REAL SYMMETRIC BAND MATRIX
C     FROM SYSIN OF ORDER  N,  AND BAND WIDTH  MB .
C     TO GENERATE THE MATRIX  ST  INITIALLY,  INITIL  IS TO BE 0.
C     TO REGENERATE THE MATRIX  ST  FOR THE PURPOSE OF THE RESIDUAL
C     CALCULATION,  INITIL  IS TO BE  1.
C
C     THIS ROUTINE IS CATALOGUED AS  EISPDRV4(RSBREADI).
C
      REAL ST(NM,MMB),STHOLD(NM,MMB)
      INTEGER  IA( 5)
      DATA IREADA/1/,IWRITE/6/
C
      IF( INITIL .EQ. 1 )  GO TO  30
      READ(IREADA,5) N,MB
    5 FORMAT(2I6)
      IF( N .EQ. 0 )  GO TO  70
      DO 8 I = 1,N
         DO 7 J = 1,MB
            ST(I,J) = 0.0E0
    7    CONTINUE
    8 CONTINUE
      DO 15 I=1,N
         MBB = MIN0(MB,N-I+1)
         READ(IREADA,10) (IA(J),J=1,MBB)
   10    FORMAT(6I12)
         DO 11 J=1,MBB
           M = MB+1-J
           K = I+J-1
   11      ST(K,M) = IA(J)
   15 CONTINUE
      DO  20  I = 1,N
         DO  20  J = 1,MB
   20      STHOLD(I,J) = ST(I,J)
      RETURN
   30 DO  40  I = 1,N
         DO  40  J = 1,MB
   40      ST(I,J) = STHOLD(I,J)
      RETURN
   70 WRITE(IWRITE,80)
   80 FORMAT(46H0END OF DATA FOR SUBROUTINE  RMATIN(RSBREADI).  /1H1)
      STOP
      END
