/*
 * Decompiled with CFR 0.152.
 */
package com.ryanharter.auto.value.gson.internal;

import com.google.errorprone.annotations.CheckReturnValue;
import com.ryanharter.auto.value.gson.internal.Util;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

@CheckReturnValue
public final class WildcardUtil {
    private WildcardUtil() {
    }

    public static WildcardType subtypeOf(Type bound) {
        return new Util.WildcardTypeImpl(new Type[]{bound}, Util.EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type bound) {
        return new Util.WildcardTypeImpl(new Type[]{Object.class}, new Type[]{bound});
    }

    static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(WildcardUtil.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return WildcardUtil.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    static boolean equals(@Nullable Type a, @Nullable Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            if (b instanceof GenericArrayType) {
                return WildcardUtil.equals(((Class)a).getComponentType(), ((GenericArrayType)b).getGenericComponentType());
            }
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            Object[] aTypeArguments = pa instanceof Util.ParameterizedTypeImpl ? ((Util.ParameterizedTypeImpl)pa).typeArguments : pa.getActualTypeArguments();
            Object[] bTypeArguments = pb instanceof Util.ParameterizedTypeImpl ? ((Util.ParameterizedTypeImpl)pb).typeArguments : pb.getActualTypeArguments();
            return WildcardUtil.equals(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(aTypeArguments, bTypeArguments);
        }
        if (a instanceof GenericArrayType) {
            if (b instanceof Class) {
                return WildcardUtil.equals(((Class)b).getComponentType(), ((GenericArrayType)a).getGenericComponentType());
            }
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return WildcardUtil.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)a;
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)a;
            TypeVariable vb = (TypeVariable)b;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }
}

