/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="The contract of Object.equals() states that for any non-null reference value x, x.equals(null) should return false. If x is null, a NullPointerException is thrown. Consider replacing equals() with the == operator.", tags={"FragileCode"}, severity=BugPattern.SeverityLevel.ERROR)
public final class EqualsNull
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> EQUALS_NULL = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceEqualsInvocation(), Matchers.argument((int)0, (Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.NULL_LITERAL))});
    private static final Matcher<Tree> INSIDE_ASSERT_CLASS = Matchers.enclosingClass((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf((String)"org.junit.Assert"), Matchers.isSubtypeOf((String)"junit.framework.Assert")}));
    private static final Matcher<Tree> ENCLOSED_BY_ASSERT = Matchers.enclosingNode((Matcher)Matchers.toType(MethodInvocationTree.class, (Matcher)MethodMatchers.staticMethod().onClassAny(new String[]{"com.google.common.truth.Truth", "com.google.common.truth.Truth8", "junit.framework.Assert", "org.junit.Assert"})));

    public Description matchMethodInvocation(MethodInvocationTree invocationTree, VisitorState state) {
        if (!EQUALS_NULL.matches((Tree)invocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isJUnitTestCode((VisitorState)state) || ASTHelpers.isTestNgTestCode((VisitorState)state) || INSIDE_ASSERT_CLASS.matches((Tree)invocationTree, state) || ENCLOSED_BY_ASSERT.matches((Tree)invocationTree, state)) {
            return Description.NO_MATCH;
        }
        Tree parentTree = state.getPath().getParentPath().getLeaf();
        boolean negated = parentTree.getKind() == Tree.Kind.LOGICAL_COMPLEMENT;
        String operator = negated ? "!=" : "==";
        Tree treeToFix = negated ? parentTree : invocationTree;
        String fixedCode = String.format("%s %s null", state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)invocationTree)), operator);
        return this.describeMatch(treeToFix, (Fix)SuggestedFix.replace((Tree)treeToFix, (String)fixedCode));
    }
}

