/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.collections;

import java.util.Collection;
import java.util.LinkedList;

public final class ListUtil {
    public static <T> LinkedList<T> filter(Collection<T> collection, Filter<T> filter) {
        LinkedList<T> filtered = new LinkedList<T>();
        for (T t : collection) {
            if (filter.isOut(t)) continue;
            filtered.add(t);
        }
        return filtered;
    }

    public static <FromT, To> LinkedList<To> convert(Collection<FromT> collection, Converter<FromT, To> converter) {
        LinkedList<To> converted = new LinkedList<To>();
        for (FromT f : collection) {
            converted.add(converter.convert(f));
        }
        return converted;
    }

    private ListUtil() {
    }

    public static interface Converter<FromT, To> {
        public To convert(FromT var1);
    }

    public static interface Filter<T> {
        public boolean isOut(T var1);
    }
}

