/* Created RJudd December 29, 1997 */
/* SPAWARSYSCEN D881 */
/**********************************************************************
// For TASP VSIPL Documentation and Code neither the United States    /
// Government, the United States Navy, nor any of their employees,    /
// makes any warranty, express or implied, including the warranties   /
// of merchantability and fitness for a particular purpose, or        /
// assumes any legal liability or responsibility for the accuracy,    /
// completeness, or usefulness of any information, apparatus,         /
// product, or process disclosed, or represents that its use would    /
// not infringe privately owned rights                                /
**********************************************************************/
/* $Id: vsip_csvsub_d.c,v 2.0 2003/02/22 15:18:47 judd Exp $ */
/* Modified RJudd June 28, 1998 */
/* to add complex block support */

#include<vsip.h>
#include<vsip_cvviewattributes_d.h>

void (vsip_csvsub_d)(
  vsip_cscalar_d alpha,
  const vsip_cvview_d *b,
  const vsip_cvview_d *r) {
  { 
      vsip_length    n = r->length;
      vsip_stride cbst = b->block->cstride,
                  crst = r->block->cstride;
      vsip_scalar_d *bpr = (vsip_scalar_d *)((b->block->R->array) + cbst * b->offset),
                    *rpr = (vsip_scalar_d *)((r->block->R->array) + crst * r->offset);
      vsip_scalar_d *bpi = (vsip_scalar_d *)((b->block->I->array) + cbst * b->offset),
                    *rpi = (vsip_scalar_d *)((r->block->I->array) + crst * r->offset);
      vsip_scalar_d tmp;
 
      /* register */ vsip_stride bst = (cbst * b->stride),
                                 rst = (crst * r->stride);
      while(n-- > 0){
         tmp  = alpha.r - *bpr;
         *rpi = alpha.i - *bpi;
         *rpr = tmp;
         bpr += bst; bpi += bst;
         rpr += rst; rpi += rst;
      }
   }
}
