/* Created RJudd August 30, 2002 */
/* SPAWARSYSCEN  */
/**********************************************************************
// For TASP VSIPL Documentation and Code neither the United States    /
// Government, the United States Navy, nor any of their employees,    /
// makes any warranty, express or implied, including the warranties   /
// of merchantability and fitness for a particular purpose, or        /
// assumes any legal liability or responsibility for the accuracy,    /
// completeness, or usefulness of any information, apparatus,         /
// product, or process disclosed, or represents that its use would    /
// not infringe privately owned rights                                /
**********************************************************************/
/* $Id: vsip_cholsol_d.c,v 2.0 2003/02/22 15:18:41 judd Exp $ */

#include<vsip.h>
#include<vsip_blockattributes_d.h>
#include<vsip_blockattributes_d.h>
#include<vsip_mviewattributes_d.h>
#include<vsip_vviewattributes_d.h>
#include<vsip_choldattributes_d.h>

#define VI_MROWVIEW_F(a_row, A, i) { \
          (a_row)->block  = (A)->block; \
          (a_row)->offset = (A)->offset + (i) * (A)->col_stride; \
          (a_row)->length = (A)->row_length; \
          (a_row)->stride = (A)->row_stride; }
#define VI_MROWSUBVIEW_F(a_row, A, i,j,n) { \
          (a_row)->block  = (A)->block; \
          (a_row)->offset = (A)->offset + (i) * (A)->col_stride + (j) * (A)->row_stride; \
          (a_row)->length = (n); \
          (a_row)->stride = (A)->row_stride; }
#define VI_MCOLSUBVIEW_F(a_col, A, i,j,n) { \
          (a_col)->block  = (A)->block; \
          (a_col)->offset = (A)->offset + (i) * (A)->col_stride + (j) * (A)->row_stride; \
          (a_col)->length = (n); \
          (a_col)->stride = (A)->col_stride; }

static
void
VI_back_spd_subt_d(
          const vsip_mview_d *A,     /* Lower Triangular used; size M by M */
          vsip_vview_d *a_row, /* a vector view on A                 */
          const vsip_mview_d *B,     /* In/out; size M by K                */
          vsip_vview_d *b_row, /* a vector view on B                 */
          vsip_vview_d *b_col) /* a vector view on B                 */
{

   vsip_length n_A = A->row_length;
   vsip_length n_B = B->row_length;
   vsip_index i,j;
   VI_MROWVIEW_F(b_row,B,n_A - 1);
   { 
      vsip_offset off = A->block->rstride * (A->offset + (n_A-1)*(A->row_stride + A->col_stride));
      vsip_scalar_d d0 = *(A->block->array + off);
      vsip_length n = b_row->length;
      vsip_stride str = b_row->stride * b_row->block->rstride;
      vsip_scalar_d *re = b_row->block->array + b_row->offset * b_row->block->rstride;
      while(n-- >0){
         *re /= d0; 
          re += str;
      }

   }

   for(i=1; i<n_A; i++){
      vsip_offset off = A->block->rstride * (A->offset + (n_A - 1 -i)*(A->row_stride + A->col_stride));
      vsip_scalar_d d = *(A->block->array + off);
      VI_MROWVIEW_F(b_row,B,n_A - 1 - i);
      VI_MCOLSUBVIEW_F(a_row,A,n_A -i ,n_A -1 - i ,i);
      for(j=0; j<n_B; j++){
         VI_MCOLSUBVIEW_F(b_col,B,n_A - i,j,i);
         { 
           vsip_scalar_d dot;
           vsip_scalar_d *b;
           vsip_length n = a_row->length;
           vsip_stride a_str = a_row->stride * a_row->block->rstride;
           vsip_stride b_str = b_col->stride * b_col->block->rstride;
           vsip_scalar_d *a_re,*b_re;
           vsip_offset off = a_row->offset * a_row->block->rstride;
           a_re = a_row->block->array + off;
           off = b_col->offset * b_col->block->rstride;
           b_re = b_col->block->array + off;
           dot = 0; 
           while(n-- > 0){
              dot += *a_re * *b_re;
              a_re += a_str;
              b_re += b_str;
           }
           off = (b_row->offset + j * b_row->stride)* b_row->block->rstride;
           b = b_row->block->array + off;
           *b = (*b - dot)/d;
         }
      }
   } 
}


static
void
VI_back_spd_sub_d(
          const vsip_mview_d *A,     /* Lower Triangular used; size M by M */
          vsip_vview_d *a_row, /* a vector view on A                 */
          const vsip_mview_d *B,     /* In/out; size M by K                */
          vsip_vview_d *b_row, /* a vector view on B                 */
          vsip_vview_d *b_col) /* a vector view on B                 */
{

   vsip_length n_A = A->row_length;
   vsip_length n_B = B->row_length;
   vsip_index i,j;
   VI_MROWVIEW_F(b_row,B,n_A - 1);
   { 
      vsip_offset off = A->block->rstride * (A->offset + (n_A-1)*(A->row_stride + A->col_stride));
      vsip_scalar_d d0 = *(A->block->array + off);
      vsip_length n = b_row->length;
      vsip_stride str = b_row->stride * b_row->block->rstride;
      vsip_scalar_d *re = b_row->block->array + b_row->offset * b_row->block->rstride;
      while(n-- >0){
         *re /= d0; 
          re += str;
      }

   }

   for(i=1; i<n_A; i++){
      vsip_offset off = A->block->rstride * (A->offset + (n_A - 1 -i)*(A->row_stride + A->col_stride));
      vsip_scalar_d d = *(A->block->array + off);
      VI_MROWVIEW_F(b_row,B,n_A - 1 - i);
      VI_MROWSUBVIEW_F(a_row,A,n_A -1 -i ,n_A - i ,i);
      for(j=0; j<n_B; j++){
         VI_MCOLSUBVIEW_F(b_col,B,n_A - i,j,i);
         { 
           vsip_scalar_d dot;
           vsip_scalar_d *b;
           vsip_length n = a_row->length;
           vsip_stride a_str = a_row->stride * a_row->block->rstride;
           vsip_stride b_str = b_col->stride * b_col->block->rstride;
           vsip_scalar_d *a_re,*b_re;
           vsip_offset off = a_row->offset * a_row->block->rstride;
           a_re = a_row->block->array + off;
           off = b_col->offset * b_col->block->rstride;
           b_re = b_col->block->array + off;
           dot = 0; 
           while(n-- > 0){
              dot += *a_re * *b_re;
              a_re += a_str;
              b_re += b_str;
           }
           off = (b_row->offset + j * b_row->stride)* b_row->block->rstride;
           b = b_row->block->array + off;
           *b = (*b - dot)/d;
         }
      }
   } 
}


static
void
VI_fwd_spd_subt_d(
          const vsip_mview_d *A,     /* Lower Triangular used; size M by M */
          vsip_vview_d *a_row, /* a vector view on A                 */
          const vsip_mview_d *B,     /* In/out; size M by K                */
          vsip_vview_d *b_row, /* a vector view on B                 */
          vsip_vview_d *b_col) /* a vector view on B                 */
{
   vsip_length n_A = A->row_length;
   vsip_length n_B = B->row_length;
   vsip_index i,j;
   VI_MROWVIEW_F(b_row,B,0);

   {  
      vsip_scalar_d d0 = *(A->block->array + A->offset * A->block->rstride);
      vsip_length n = b_row->length;
      vsip_stride str = b_row->stride * b_row->block->rstride;
      vsip_scalar_d *re = b_row->block->array + b_row->offset * b_row->block->rstride;
      while(n-- >0){
         *re /= d0; 
          re += str;
      }
      
   }
   for(i=1; i<n_A; i++){
      vsip_scalar_d d = *(A->block->array + (A->offset + i * (A->row_stride +A->col_stride)) * A->block->rstride);
      VI_MROWVIEW_F(b_row,B,i);
      VI_MCOLSUBVIEW_F(a_row,A,0,i,i);
      for(j=0; j<n_B; j++){
         VI_MCOLSUBVIEW_F(b_col,B,0,j,i);
         { 
           vsip_scalar_d dot;
           vsip_scalar_d *b;
           vsip_length n = a_row->length;
           vsip_stride a_str = a_row->stride * a_row->block->rstride;
           vsip_stride b_str = b_col->stride * b_col->block->rstride;
           vsip_scalar_d *a_re,*b_re;
           vsip_offset off = a_row->offset * a_row->block->rstride;
           a_re = a_row->block->array + off;
           off = b_col->offset * b_col->block->rstride;
           b_re = b_col->block->array + off;
           dot = 0;
           while(n-- > 0){
              dot += *a_re * *b_re;
              a_re += a_str;
              b_re += b_str;
           }
           off = (b_row->offset + j * b_row->stride)* b_row->block->rstride;
           b = b_row->block->array + off;
           *b = (*b - dot)/d;
         }
      }
   } 
}

static
void
VI_fwd_spd_sub_d(
          const vsip_mview_d *A,     /* Lower Triangular used; size M by M */
          vsip_vview_d *a_row, /* a vector view on A                 */
          const vsip_mview_d *B,     /* In/out; size M by K                */
          vsip_vview_d *b_row, /* a vector view on B                 */
          vsip_vview_d *b_col) /* a vector view on B                 */
{
   vsip_length n_A = A->row_length;
   vsip_length n_B = B->row_length;
   vsip_index i,j;
   VI_MROWVIEW_F(b_row,B,0);

   {  
      vsip_scalar_d d0 = *(A->block->array + A->offset * A->block->rstride);
      vsip_length n = b_row->length;
      vsip_stride str = b_row->stride * b_row->block->rstride;
      vsip_scalar_d *re = b_row->block->array + b_row->offset * b_row->block->rstride;
      while(n-- >0){
         *re /= d0; 
          re += str;
      }
      
   }
   for(i=1; i<n_A; i++){
      vsip_scalar_d d = *(A->block->array + (A->offset + i * (A->row_stride +A->col_stride)) * A->block->rstride);
      VI_MROWVIEW_F(b_row,B,i);
      VI_MROWSUBVIEW_F(a_row,A,i,0,i);
      for(j=0; j<n_B; j++){
         VI_MCOLSUBVIEW_F(b_col,B,0,j,i);
         { 
           vsip_scalar_d dot;
           vsip_scalar_d *b;
           vsip_length n = a_row->length;
           vsip_stride a_str = a_row->stride * a_row->block->rstride;
           vsip_stride b_str = b_col->stride * b_col->block->rstride;
           vsip_scalar_d *a_re,*b_re;
           vsip_offset off = a_row->offset * a_row->block->rstride;
           a_re = a_row->block->array + off;
           off = b_col->offset * b_col->block->rstride;
           b_re = b_col->block->array + off;
           dot = 0;
           while(n-- > 0){
              dot += *a_re * *b_re;
              a_re += a_str;
              b_re += b_str;
           }
           off = (b_row->offset + j * b_row->stride)* b_row->block->rstride;
           b = b_row->block->array + off;
           *b = (*b - dot)/d;
         }
      }
   } 
}

int
vsip_cholsol_d(
          const vsip_chol_d *chol,
          const vsip_mview_d *XB)
{
   int retval = 0;
   vsip_vview_d aa_row,bb_row,bb_col;
   vsip_vview_d *a_row = &aa_row,*b_row = &bb_row,*b_col = &bb_col;
   if(chol->uplo == VSIP_TR_UPP){
      VI_fwd_spd_subt_d(chol->matrix,a_row,XB,b_row,b_col);
      VI_back_spd_sub_d(chol->matrix,a_row,XB,b_row,b_col);
   } else { /* must be VSIP_TR_LOW */
      VI_fwd_spd_sub_d(chol->matrix,a_row,XB,b_row,b_col);
      VI_back_spd_subt_d(chol->matrix,a_row,XB,b_row,b_col);
   }
   return retval;
}  
