/* Created RJudd August 30, 2002 */
/* SPAWARSYSCEN  */
/**********************************************************************
// For TASP VSIPL Documentation and Code neither the United States    /
// Government, the United States Navy, nor any of their employees,    /
// makes any warranty, express or implied, including the warranties   /
// of merchantability and fitness for a particular purpose, or        /
// assumes any legal liability or responsibility for the accuracy,    /
// completeness, or usefulness of any information, apparatus,         /
// product, or process disclosed, or represents that its use would    /
// not infringe privately owned rights                                /
**********************************************************************/
/* $Id: vsip_chold_d.c,v 2.0 2003/02/22 15:18:41 judd Exp $ */

#include<vsip.h>
#include<vsip_mviewattributes_d.h>
#include<vsip_vviewattributes_d.h>
#include<vsip_choldattributes_d.h>

#define VI_MCOLSUBVIEW_F(a_col, A, i,j,n) { \
          (a_col)->block  = (A)->block; \
          (a_col)->offset = (A)->offset + (i) * (A)->col_stride + (j) * (A)->row_stride; \
          (a_col)->length = (n); \
          (a_col)->stride = (A)->col_stride; }

#define VI_MROWSUBVIEW_F(a_row, A, i,j,n) { \
          (a_row)->block  = (A)->block; \
          (a_row)->offset = (A)->offset + (i) * (A)->col_stride + (j) * (A)->row_stride; \
          (a_row)->length = (n); \
          (a_row)->stride = (A)->row_stride; }

static
int
VI_cholesky_low_d(
          const vsip_mview_d *A)
{
   int retval = 0;
   vsip_index j,k;
   vsip_length nn = A->col_length;
   vsip_vview_d aa_col,bb_col;
   vsip_vview_d *a_col = &aa_col, *b_col =&bb_col;
   for(k=0; k<nn; k++){
      vsip_scalar_d *a_kk = A->block->array + A->block->rstride *(A->offset + k * (A->row_stride + A->col_stride));
      if(*a_kk <= 0) retval++;
      *a_kk = sqrt(*a_kk);
      VI_MCOLSUBVIEW_F(a_col,A,k+1,k,nn-k-1);
      {  
         vsip_length n = a_col->length;
         vsip_scalar_d scale = *a_kk;
         vsip_stride a_str  = a_col->stride * a_col->block->rstride;
         vsip_scalar_d *a_ptr = a_col->block->array  + a_col->block->rstride * a_col->offset;
         while(n-- > 0){
            *a_ptr = *a_ptr / scale;
             a_ptr += a_str;
         }
      }
      for(j=k+1; j<nn; j++){
         VI_MCOLSUBVIEW_F(a_col,A,j,j,nn-j);
         VI_MCOLSUBVIEW_F(b_col,A,j,k,nn-j);
         { 
            vsip_length n = b_col->length;
            vsip_scalar_d *a_ptr = a_col->block->array  + a_col->block->rstride * a_col->offset;
            vsip_scalar_d *b_ptr = b_col->block->array  + b_col->block->rstride * b_col->offset;
            vsip_scalar_d scale = *(A->block->array + A->block->rstride * (A->offset + j * A->col_stride + k * A->row_stride));
            vsip_stride a_str = a_col->block->rstride * a_col->stride;
            vsip_stride b_str = b_col->block->rstride * b_col->stride;
            while(n-- >0){
               *a_ptr -= *b_ptr * scale;
                a_ptr += a_str; b_ptr += b_str;
            }
         }
      }
   }
   return retval;
}

static
int
VI_cholesky_upp_d(
          const vsip_mview_d *A)
{
   int retval = 0;
   vsip_index j,k;
   vsip_length nn = A->row_length;
   vsip_vview_d aa_row,bb_row;
   vsip_vview_d *a_row = &aa_row, *b_row = &bb_row;
   for(k=0; k<nn; k++){
      vsip_scalar_d *a_kk = A->block->array + A->block->rstride *(A->offset + k * (A->row_stride + A->col_stride));
      if(*a_kk <= 0) retval++;
      *a_kk = sqrt(*a_kk);
      VI_MROWSUBVIEW_F(a_row,A,k,k+1,nn-k-1);
      {
         vsip_length n = a_row->length;
         vsip_scalar_d scale = *a_kk;
         vsip_stride a_str  = a_row->stride * a_row->block->rstride;
         vsip_scalar_d *a_ptr = a_row->block->array  + a_row->block->rstride * a_row->offset;
         while(n-- > 0){
            *a_ptr = *a_ptr / scale;
             a_ptr += a_str;
         }
      }
      for(j=k+1; j<nn; j++){
         VI_MROWSUBVIEW_F(a_row,A,j,j,nn-j);
         VI_MROWSUBVIEW_F(b_row,A,k,j,nn-j);
         {  
            vsip_length n = b_row->length;
            vsip_scalar_d *a_ptr = a_row->block->array  + a_row->block->rstride * a_row->offset;
            vsip_scalar_d *b_ptr = b_row->block->array  + b_row->block->rstride * b_row->offset;
            vsip_scalar_d scale = *(A->block->array + A->block->rstride * (A->offset + j * A->row_stride + k * A->col_stride));
            vsip_stride a_str = a_row->block->rstride * a_row->stride;
            vsip_stride b_str = b_row->block->rstride * b_row->stride;
            while(n-- >0){
               *a_ptr -= *b_ptr * scale;
                a_ptr += a_str; b_ptr += b_str;
            }
         }
      }
   }
   return retval;
}

int
vsip_chold_d(
          vsip_chol_d* chol,
          const vsip_mview_d *A)
{
   int retval = 0;
   chol->matrix = A;
   if(chol->uplo == VSIP_TR_LOW){
      retval += VI_cholesky_low_d(A);
   } else { /* must be vsip_tr_upp */
      retval += VI_cholesky_upp_d(A);
   } 
   return retval;
}
