/* Created RJudd September 16, 2000 */
/* SPAWARSYSCEN D857                */
/**********************************************************************
// For TASP VSIPL Documentation and Code neither the United States    /
// Government, the United States Navy, nor any of their employees,    /
// makes any warranty, express or implied, including the warranties   /
// of merchantability and fitness for a particular purpose, or        /
// assumes any legal liability or responsibility for the accuracy,    /
// completeness, or usefulness of any information, apparatus,         /
// product, or process disclosed, or represents that its use would    /
// not infringe privately owned rights                                /
**********************************************************************/
/* $Id: vsip_blockcreate_f.c,v 2.0 2003/02/22 15:18:37 judd Exp $ */

#include<vsip.h>
#include<vsip_blockattributes_f.h>

vsip_block_f* (vsip_blockcreate_f)(
  size_t N, 
  vsip_memory_hint h) {
  vsip_block_f* b = (vsip_block_f*)malloc(sizeof(vsip_block_f));
  if(b != NULL){
      b->array = (vsip_scalar_f*)malloc(N * sizeof(vsip_scalar_f));
      if(b->array == (vsip_scalar_f*)NULL){
         free((void*)b);
         b = (vsip_block_f*)NULL;
      } else {
         b->kind     = VSIP_VSIPL_BLOCK;
         b->admit    = VSIP_ADMITTED_BLOCK;
         b->markings = VSIP_VALID_STRUCTURE_OBJECT;
         b->size     = N; /* size in block elements */
         b->rstride  = 1;
         b->bindings = 0;
         b->parent = (vsip_cblock_f*)NULL;
      }
  }
  return b;
}
