/* Created RJudd September 26,  1997 */
/* SPAWARSYSCEN D881 */
/**********************************************************************
// For TASP VSIPL Documentation and Code neither the United States    /
// Government, the United States Navy, nor any of their employees,    /
// makes any warranty, express or implied, including the warranties   /
// of merchantability and fitness for a particular purpose, or        /
// assumes any legal liability or responsibility for the accuracy,    /
// completeness, or usefulness of any information, apparatus,         /
// product, or process disclosed, or represents that its use would    /
// not infringe privately owned rights                                /
**********************************************************************/
/* $Id: VI_veuler_f.h,v 2.0 2003/02/22 15:18:34 judd Exp $ */

#include<vsip.h>
#include<vsip_vviewattributes_f.h>
#include<vsip_cvviewattributes_f.h>
#ifndef VI_VEULER_F_H
#define VI_VEULER_F_H

static
void 
VI_veuler_f(
  const vsip_vview_f* a,
  const vsip_cvview_f* r) {
  { 
      /* register */ vsip_length n = r->length;
      vsip_stride crst = r->block->cstride,
                  rast = a->block->rstride;
      vsip_scalar_f *ap  = (vsip_scalar_f*) ((a->block->array) + a->offset * rast),
                    *rpr = (vsip_scalar_f*) ((r->block->R->array) + crst * r->offset);
      vsip_scalar_f *rpi = (vsip_scalar_f*) ((r->block->I->array) + crst * r->offset);
      vsip_scalar_f  temp;
      /* register */ vsip_stride ast = a->stride * rast,
                                 rst = (crst * r->stride);
      while(n-- > 0){
          temp = (vsip_scalar_f)cos(*ap);
          *rpi = (vsip_scalar_f)sin(*ap);
          *rpr = temp;
          ap  += ast; 
          rpr += rst; rpi += rst;
      }

  }
}
#endif
