/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    {
        // Test import bankperfect
        SKGError err;
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true) {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_BP_CSV"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportcsv/bankperfect.csv"));
            SKGTESTERROR(QLatin1String("imp1.importFile"), imp1.importFile(), true)
        }

        {
            SKGBEGINTRANSACTION(document1, QLatin1String("AUTORECONCILE"), err)
            SKGAccountObject account1(&document1);
            SKGTESTERROR(QLatin1String("ACCOUNT.setName"), account1.setName(QLatin1String("bankperfect")), true)
            SKGTESTERROR(QLatin1String("ACCOUNT.load"), account1.load(), true)
            auto soluces = account1.getPossibleReconciliations(3547.14);
            SKGTEST(QLatin1String("ACCOUNT.getPossibleReconciliations"), soluces.count(), 1)
            SKGTESTERROR(QLatin1String("ACCOUNT.autoReconcile"), account1.autoReconcile(3547.14), true)
        }
    }

    {
        // Test import bankperfect
        SKGError err;
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.load()"), document1.load(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestautoreconcile/complex.skg"), true) {
            SKGBEGINTRANSACTION(document1, QLatin1String("AUTORECONCILE"), err) {
                SKGAccountObject account1(&document1);
                SKGTESTERROR(QLatin1String("ACCOUNT.setName"), account1.setName(QLatin1String("EURO")), true)
                SKGTESTERROR(QLatin1String("ACCOUNT.load"), account1.load(), true)
                auto soluces = account1.getPossibleReconciliations(3699.67);
                SKGTEST(QLatin1String("ACCOUNT.getPossibleReconciliations"), soluces.count(), 1)
                SKGTESTERROR(QLatin1String("ACCOUNT.autoReconcile"), account1.autoReconcile(3699.67), true)

                soluces = account1.getPossibleReconciliations(3699.67);
                SKGTEST(QLatin1String("ACCOUNT.getPossibleReconciliations"), soluces.count(), 1)
                SKGTESTERROR(QLatin1String("ACCOUNT.autoReconcile"), account1.autoReconcile(3699.67), true)
            }

            {
                SKGAccountObject account1(&document1);
                SKGTESTERROR(QLatin1String("ACCOUNT.setName"), account1.setName(QLatin1String("DOLLAR")), true)
                SKGTESTERROR(QLatin1String("ACCOUNT.load"), account1.load(), true)
                auto soluces = account1.getPossibleReconciliations(3699.67);
                SKGTEST(QLatin1String("ACCOUNT.getPossibleReconciliations"), soluces.count(), 1)
                SKGTESTERROR(QLatin1String("ACCOUNT.autoReconcile"), account1.autoReconcile(3699.67), true)

                SKGTESTERROR(QLatin1String("ACCOUNT.autoReconcile"), account1.autoReconcile(3699.67), true)
            }
        }
    }

    {
        // Test many combinations
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT"), err)
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestautoreconcile/many_combinations.csv"));
            SKGTESTERROR(QLatin1String("CSV.importFile"), imp1.importFile(), true)
            document1.dump(DUMPOPERATION | DUMPACCOUNT);
        }

        {
            SKGAccountObject account1(&document1);
            SKGTESTERROR(QLatin1String("ACCOUNT.setName"), account1.setName(QLatin1String("many combinations")), true)
            SKGTESTERROR(QLatin1String("ACCOUNT.load"), account1.load(), true)
            auto soluces = account1.getPossibleReconciliations(53, true);
            SKGTEST(QLatin1String("ACCOUNT.getPossibleReconciliations"), soluces.count(), 1)

            SKGBEGINTRANSACTION(document1, QLatin1String("CREATE OPERATIONS"), err)
            double oBalance;
            SKGUnitObject oUnit;
            QDate now = QDate::currentDate();
            account1.getInitialBalance(oBalance, oUnit);
            int nb = 38;
            for (int i = 1; i <= nb; ++i) {
                SKGOperationObject op;
                SKGTESTERROR(QLatin1String("ACCOUNT:addOperation"), account1.addOperation(op), true)
                SKGTESTERROR(QLatin1String("OPE:setDate"), op.setDate(now), true)
                SKGTESTERROR(QLatin1String("OPE:setUnit"), op.setUnit(oUnit), true)
                SKGTESTERROR(QLatin1String("OPE:setImported"), op.setImported(true), true)
                SKGTESTERROR(QLatin1String("OPE:save"), op.save(), true)

                SKGSubOperationObject subop;
                SKGTESTERROR(QLatin1String("OPE:addSubOperation"), op.addSubOperation(subop), true)
                SKGTESTERROR(QLatin1String("OPE:setQuantity"), subop.setQuantity(10), true)
                SKGTESTERROR(QLatin1String("SUBOPE:save"), subop.save(), true)
            }

            // Test performance
            soluces = account1.getPossibleReconciliations(-23 + 10 * nb, true);
        }
    }
    // End test
    SKGENDTEST()
}
