/***************************************************************************
                          transaction.cpp  -  description
                             -------------------
    begin                : Sat Aug 10 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: transaction.cpp,v 1.6 2002/09/04 04:05:00 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtextstream.h>

#include "transaction.h"
#include "kbudgetdoc.h"

Transaction::Transaction() {
}

Transaction::Transaction(KBudgetDoc* doc, int id, QTextStream &stream, int version)
{
  m_doc = doc;
  m_id = id;
  int year, month, day;
  stream >> m_from >> m_to >> m_value >> year >> month >> day;
  m_date.setYMD(year, month, day);
  m_description = stream.readLine().stripWhiteSpace();

  if ( version == 2 );
}

Transaction::Transaction(KBudgetDoc* d, int i, int from, int to, float val, QDate dt, QString desc)
{
	m_from = from;
	m_to = to;
	m_value = val;
	m_date = dt;
	m_description = desc;
	m_doc = d;
	m_id = i;
}

Transaction::~Transaction() {
}

void Transaction::serialize(QTextStream &stream)
{
  stream << QString("Transaction %1 %2 %3 %4 %5 %6 %7 %8\n")\
    .arg(m_id).arg(m_from).arg(m_to).arg(m_value).arg(m_date.year())\
    .arg(m_date.month()).arg(m_date.day()).arg(m_description);
}

int Transaction::id() const
{
  return m_id;
}

int Transaction::from() const
{
  return m_from;
}

int Transaction::to() const
{
  return m_to;
}

float Transaction::value() const
{
  return m_value;
}

QDate Transaction::date() const
{
  return m_date;
}

QString Transaction::description() const
{
  return m_description;
}

void Transaction::setData(float val, QDate d, QString desc)
{
  m_doc->getAccount(m_from).removeTransaction(m_id);
  m_doc->getAccount(m_to).removeTransaction(m_id);
  m_value = val;
  m_date = d;
  m_description = desc;
  m_doc->getAccount(m_from).addTransaction(m_id);
  m_doc->getAccount(m_to).addTransaction(m_id);
}
