/***************************************************************************
                          synk.h  -  description
                             -------------------
    begin                : Sat Aug 18 13:48:33 NZST 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYNK_H
#define SYNK_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kaction.h>
#include <kapplication.h>
#include "ktransferkio.h"
#include "ksynkconnection.h"
#include <kmainwindow.h>
#include <qguardedptr.h>
#include "kconnectionlist.h"
#include "ktransferdetailswidgetimpl.h"

class ConnectionEditDialog;
class QPopupMenu;
class QSplitter;

/** SynK is the base class of the project */
class SynK : public KMainWindow
{
    Q_OBJECT
	
public:
    /** construtor */
    SynK(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~SynK();
    /** Saves the list of connections */
    void saveConnections();
    /** Loads the list of connections */
    void loadConnections();

public slots: // Public slots
    /** Handles completion of the transfer */
    void slotTransferComplete();

protected:
    QGuardedPtr<KTransferKIO> transfer;
    KConnectionList *ConnectionList	;
    ConnectionEditDialog *m_connectionEditDialog;
    KTransferDetailsWidgetImpl *TransferDetails;
    virtual void closeEvent (QCloseEvent *qcloseevent);
    /** Sets up the toolbars, actions etc */
    void initGUI();

protected slots: // Public slots
    /** Performs the synchronisation on the selected connection */
    void slotSynchronise();

    /** Edits the specified connection */
    void slotEditConnection();

    /** Removes a connection from the list */
    void slotRemoveConnection();

    /** Adds a new connection to the list,. */
    void slotAddConnection();

    /** Creates a new connection, copying the current connection's values */
    void slotCopyConnection();

    /** Handles a request to cancel the current transfer */
    void slotCancelTransfer();

    void slotConfigFinished();

    void slotConfigCanceled();

    void slotSelectionChanged();
    
    void slotContextMenu( QListViewItem *item, const QPoint& pos, int col );

private:
    void editConnection( const KSynkConnection& );

    bool m_isNewAccount;
    QSplitter *vsplit;
    KAction *m_addAct, *m_editAct, *m_copyAct, *m_removeAct, *m_syncAct;
    QPopupMenu *m_popup;
};

#endif
