/***************************************************************************
                          ktransferkio.h  -  description
                             -------------------
    begin                : Thu Aug 9 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSYNCTRANSFERKIO_H
#define KSYNCTRANSFERKIO_H

#include <qobject.h>
#include <kio/jobclasses.h>
#include "ksynkconnection.h"
#include "ktransfer.h"
#include "krecursivelister.h"
#include <kfileitem.h>
#include <qguardedptr.h>
#include <qptrqueue.h>
/**Backend class that handles the transfer
 *@author Jonathon Sim
 */

class KTransferKIO : public KTransfer  {
    Q_OBJECT

public:
    KTransferKIO(const KSynkConnection & connection);
    ~KTransferKIO();
    /** Self explanatory really.   */
    void transfer();
    /** Stops, and deletes the current transfer.  */
    void kill();

signals:
    /** Emitted when it is determined which files we need to get */
    void signalGettingFiles(const KURL::List& files);
    /** Emitted when a batch of files has been copied */
    void signalFilesComplete(const KURL::List & filename);
    void signalFilesCanceled(const KURL::List& files);
    void signalFilesError(const KURL::List& files );
    /** Emitted when a transfer error occurs */
    void signalTransferError(const QString & reason);

protected slots:
    /** Handles completion of the transfer */
    void slotTransferResult(KIO::Job*);

    /** Emitted to update percentage bar */
    void slotPercent(KIO::Job* job,unsigned long percent);
    /** Handle the completion of the listing */
    void slotListingResult();
    void slotCopying( KIO::Job *, const KURL& from, const KURL& to );

protected:
    KFileItemList	localfilelist;  //Files found at local url
    KFileItemList	remotefilelist; //Files found at remote url
    KFileItemList 	remotedirtree;  //Directory structure of remote url
    QGuardedPtr<KRecursiveLister> dirlister; //The current directory lister
    QGuardedPtr<KIO::Job> transferjob;  //The currently active transfer job
    bool finished; //Set to true when the transfer is complete.
    struct TransferDescriptor { //Used to describe part of a transfer (into one directory)
        KURL::List sources;
        KURL dest;
    };
    typedef QPtrQueue<TransferDescriptor> TransferQueue;		
    TransferQueue  * transferqueue; //The queue of transfers

	
    /** Determines which files in the list need to be updated */
    KFileItemList * findChanged();

    /** Starts finding a listing of all directories matching the current connections filter. */
    void startListing(KURL url,const QString & name);

    /** Helper function that will convert a url to a relative url */
    QString makeRelative(const KURL&url,const KURL & relativeto);

    /** The function that actually begins the transfer. */
    void transferFiles(const KURL::List& source,const KURL& dest);

    /** Starts the next transfer in the queue */
    void nextTransfer();

    /** Duplicates the sub-directory structure of the remote url locally, as a preliminary to copying files into it */
    void createDirs();

    /** Creates the queue of transfers for the copy job. */

    KTransferKIO::TransferQueue* makeTransferQueue(const KURL::List & urllist);

    /** Converts the specified remote url to the corresponding local url */
    KURL remoteToLocal(const KURL & url);

};

#endif
