/***************************************************************************
                          ktransferdetailswidgetimpl.h  -  description
                             -------------------
    begin                : Thu Aug 30 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSFERDETAILSWIDGETIMPL_H
#define KTRANSFERDETAILSWIDGETIMPL_H

#include <transferdetailswidget.h>
#include <kurl.h>
#include <qdict.h>
#include <klistview.h>

/**A composite widget that displays the details of a transfer
 *@author Jonathon Sim
 */

class KSynkConnection;

class KTransferDetailsWidgetImpl : public TransferDetailsWidget  {
    Q_OBJECT

public:
    KTransferDetailsWidgetImpl(QWidget *parent=0, const char *name=0);
    ~KTransferDetailsWidgetImpl();
    /** Sets the widget up for the start of a transfer */
    void start( const KSynkConnection *connection );
    /** Sets the transfer dialog to its end-of-transfer state*/
    void setClearStatus();

signals: // Signals
    /** Emitted when the uses asks to cancel the transfer */
    void signalCancelTransfer();

public slots: // Public slots
    /** Updates list to reflect that we a getting specified files */
    void slotGettingFile(const KURL::List & files);
    /** The transfer is complete */
    void slotTransferComplete();
    /** Sets the value of the percentage bar */
    void slotPercent(unsigned long percent, unsigned long);
    /** so the widget may be informed when files have been recieved */
    void slotFilesDone(const KURL::List & files);
    void slotCanceled( const KURL::List& files );
    void slotError( const KURL::List& files );
    /** Displays message sent by the transfer class */
    void slotMessage(const QString & message);

protected slots:
    /** Cancels the current transfer */
    void slotCancelTransfer();
    /** Clears the current transfer, sets everything back to defaults */
    void clear();

protected:
    QDict<KListViewItem> listitems;
    const KSynkConnection *m_connection;

protected:
    static QString makeRelative( const QString& start, const KURL& end );
    void setStatusText( const KURL::List& files, const QString& statusText );

};

#endif
