/*
 * KHeiseReg
 *
 * A utility to search for articles within the Heise register.
 *
 * Copyright (C) 2002 Oliver Gantz <Oliver.Gantz@ePost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>

#include <qglobal.h>
#include <qstring.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kuniqueapplication.h>
#include <klocale.h>

#include "kheisereg.h"


static const char *description =
	I18N_NOOP("A utility to search within the Heise register.");
	
	
int main(int argc, char *argv[])
{
	KAboutData aboutData("kheisereg", I18N_NOOP("KHeiseReg"),
		VERSION, description, KAboutData::License_GPL,
		"(C) 2002 Oliver Gantz",
		0,
		"http://www.gantz-edv.de/kheisereg/",
		"Oliver.Gantz@ePost.de");
	
	aboutData.addAuthor("Oliver Gantz", 0, "Oliver.Gantz@ePost.de");
	KCmdLineArgs::init(argc, argv, &aboutData);

	if (!KUniqueApplication::start())
		exit(0);

	KUniqueApplication a;
 
	KHeiseReg *kheisereg = new KHeiseReg(0, "mainwindow");
	Q_CHECK_PTR(kheisereg);
	a.setMainWidget(kheisereg);
	kheisereg->setCaption(QString::null);
	kheisereg->show();

	return a.exec();
}  
