/*
 * KHeiseReg
 *
 * A utility to search for articles within the Heise register.
 *
 * Copyright (C) 2002 Oliver Gantz <Oliver.Gantz@ePost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GLOBAL_H
#define GLOBAL_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qstring.h>

#define REGISTER_FILE							"content.reg"
#define DOWNLOAD_DIR							"download"

#define ID_PREF_GROUP_GENERAL			"General"
#define ID_PREF_GEN_TOOLTIPS			"ToolTips"
#define PREF_GEN_TOOLTIPS					true

#define ID_PREF_GROUP_SEARCH		"Search"
#define ID_PREF_SEA_BYWORDS			"Bywords"
#define PREF_SEA_BYWORDS				""
#define ID_PREF_SEA_AUTHORS			"Authors"
#define PREF_SEA_AUTHORS				""
#define ID_PREF_SEA_EDITORS			"Editors"
#define PREF_SEA_EDITORS				""
#define ID_PREF_SEA_EDITIONS		"Editions"
#define PREF_SEA_EDITIONS				""
#define ID_PREF_SEA_YEARS				"Years"
#define PREF_SEA_YEARS					""
#define ID_PREF_SEA_CTMAG				"ct"
#define PREF_SEA_CTMAG					true
#define ID_PREF_SEA_IXMAG				"ix"
#define PREF_SEA_IXMAG					true
#define ID_PREF_SEA_CASE				"CaseSensitive"
#define PREF_SEA_CASE						false
#define ID_PREF_SEA_FUZZY				"Fuzzy"
#define PREF_SEA_FUZZY					false
#define ID_PREF_SEA_CUMUL				"Cumulative"
#define PREF_SEA_CUMUL					false
#define ID_PREF_SEA_THRESHOLD		"Threshold"
#define PREF_SEA_THRESHOLD			100

#define ID_PREF_GROUP_NETWORK		"Network"
#define ID_PREF_NET_CTURL				"ctFTPDirectory"
#define PREF_NET_CTURL					"ftp://ftp.heise.de/pub/ct/inhalt/"
#define ID_PREF_NET_IXURL				"ixFTPDirectory"
#define PREF_NET_IXURL					"ftp://ftp.heise.de/pub/ix/inhalt/"

#define ID_PREF_GROUP_CDROM				"CD-ROM"
#define ID_PREF_CDROM_CTDIR				"ctROMDirectory"
#define PREF_CDROM_CTDIR					"/mnt"
#define ID_PREF_CDROM_IXDIR				"ixROMDirectory"
#define PREF_CDROM_IXDIR					"/mnt"
#define ID_PREF_CDROM_ALTBROWSER	"UseAlternativeBrowser"
#define PREF_CDROM_ALTBROWSER			false
#define ID_PREF_CDROM_BROWSERCOM	"BrowserCommand"
#define PREF_CDROM_BROWSERCOM			"mozilla %u"



#define ID_HELP_CONTENTS           1002
#define ID_HELP_ABOUT              1003

#define ID_STATUS_MSG              1001
#define ID_STATUS_ITEMS            1002



QString expandPath(const QString &fname);


#endif // GLOBAL_H
