/***************************************************************************
                          selection.h  -  description                              
                             -------------------                                         
    begin                : Tue Sep 7 1999                                           
    copyright            : (C) 1999 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "selectiondata.h"
#include "kaspabase.h"
#include "resource.h"

#ifndef selection_included
#define selection_included

class Selection : public SelectionData {
    Q_OBJECT

private:
	Selection(const Selection&);
	Selection& operator=(const Selection&);

protected:
	Title *list;

public:

  Selection(QWidget* parent, const char* name, const char *caption);
  virtual ~Selection();

  /** Creates a toolbar and alters the menu. Called by the constructors.
   */
  virtual void setWorkingGUI();
  virtual void setReadOnlyGUI();
  virtual void setInvalidGUI();
  virtual void setReadWriteGUI();

  /** Locks GUI, if invalid and returns status.
   */
  virtual bool isValid();
  virtual bool closeRequest();
  virtual void setFields();
	virtual Title *getList()=0;
	virtual bool isWorking()=0;
	virtual bool isReadOnly() { return false; };
	KToolBar *getToolBar();
public slots:
	void reread();
	virtual void open(Oid o, bool w)=0;
};

#endif
























