/***************************************************************************
                          filelinklistbox.h  -  description
                             -------------------
    begin                : Fri Aug 31 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILELINKLISTBOX_H
#define FILELINKLISTBOX_H

#include <qwidget.h>
#include <linklistbox.h>
#include <qdragobject.h>
#include <qpopupmenu.h>

class QStrList;

/**
  *@author Jan Mueller
  */

class FileLinkListBox : public LinkListBox  {
   Q_OBJECT
private:
	FileLinkListBox(const FileLinkListBox&);
	FileLinkListBox& operator=(const FileLinkListBox&);
  QPopupMenu dndpop;

protected slots:
  void slotDeleteFiles();
  void slotExportFiles();

signals:
  void importFiles(QStrList);
  void createReferences(QStrList);
  void save();
  void reset();
  void deleteFiles();
  void exportFiles();

public:
	FileLinkListBox(QWidget *parent=0, const char *name=0);
	~FileLinkListBox();
  void dragEnterEvent(QDragEnterEvent* e);
  void dropEvent(QDropEvent* e);
};

#endif
