/***************************************************************************
                          bibliography.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: bibliography.h
	Last generated: Fri Sep 24 20:55:34 1999

 *********************************************************************/

#ifndef Bibliography_included
#define Bibliography_included

#include "bibliographydata.h"
#include "publbase.h"
#include "kaspaurl.h"
#include "bibtexfactory.h"

class QWidget;
class BibTexFields;
class QBoxLayout;
class KaspaURL;
/** GUI-class for Bibliographys
 */
class Bibliography : public BibliographyData
{
private:
		Bibliography(const Bibliography&);
		Bibliography& operator=(const Bibliography&);

    Q_OBJECT

protected:
    PublBase *publ;
    BibTexFields *btfields;
		QBoxLayout *layout;
		KaspaURL _url;
		BibTexFactory bt;

		void save(bool block=false);

public:
    virtual void setFields();
    /** Load biblio from WHERE clause. Must not return more than one row. Calls init().
     */
    Bibliography(KaspaURL url, Sql *conn, QWidget* parent, const char* name);

    /** Updates table, if data has changed and is not read-only. Deletes toolbar and menuitems.
	Clears any messages in the statusline.
    */
    virtual ~Bibliography();

    /** Locks GUI.
     */
    virtual void setWorkingGUI();

    /** Unlocks the fields.
     */
    virtual void setReadOnlyGUI();
    virtual void setInvalidGUI();
    virtual void setReadWriteGUI();

    /** Locks GUI, if invalid and returns status.
     */
    virtual bool isValid();
    virtual bool isWorking() { return publ->isWorking(); }
    virtual bool isReadOnly() { return publ->isReadOnly(); }
    virtual bool closeRequest();
    virtual const char *url() { return _url; }

    KToolBar *getToolBar();

 public slots:
    /** Rereads data from table. Sends message with(out) timeout to statusline (if failed).
     */
    virtual void reread();

    /** Flushes data. Sends message with timeout to statusline.
     */
    virtual void flush();

    /** Import image from file. Sends message with timeout to statusline.
     */

    /** Deletes row. Sends permanent messages to statusline.
     */
    virtual void del();

	 	/** Insert Publisher.
		 */
		virtual void insertOrgPublisher();

		/** New Publisher.
		*/
		virtual void newOrgPublisher();

		/** Show Publisher.
		*/
		virtual void showOrgPublisher();
		virtual void showPubl();

		virtual void generateBibTex();

};
#endif // Bibliography_included







