/***************************************************************************
                          bibliography.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: bibliography.cpp
	Last generated: Fri Sep 24 20:55:34 1999

 *********************************************************************/

#define Inherited BibliographyData

#include <kapp.h>
#include <qstring.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <klocale.h>
#include <qwhatsthis.h>
#include <qlayout.h>

#include "bibliography.h"
#include "kaspawidget.h"
#include "resource.h"
#include "journal.h"
#include "book.h"
#include "booklet.h"
#include "collection.h"
#include "proceedings.h"
#include "manual.h"
#include "techreport.h"
#include "masterthesis.h"
#include "misc.h"
#include "unpublished.h"
#include "selectiondlg.h"


CommandSetup bibliocs[] = {	{ID_BIBLIO_DELREC,					RW},
														{ID_BIBLIO_SHOWPUBL,				RW+RO},
														{ID_BIBLIO_FLUSH,						RW},
														{ID_BIBLIO_SHOWORGPUBLISHER,RW+RO},
														{ID_BIBLIO_INSORGPUBLISHER, RW+RO},
														{ID_BIBLIO_NEWORGPUBLISHER, RW+RO},
														{ID_BIBLIO_RESET,						RW+RO+INV} };


// BibliographyBase-Constructor reads row matching WHERE-Clause.
Bibliography::Bibliography(KaspaURL url, Sql *conn, QWidget* parent,	const char* name=0L):
  Inherited( parent, name), btfields(0L), layout(0L) {
	setTabOrder(subtitle, bibtex);
	setTabOrder(bibtex, translator);
	setTabOrder(translator, orgyear);
	setTabOrder(orgyear, orgpublisher);
	setTabOrder(orgpublisher, orgtitle);
	setTabOrder(orgtitle, isbn_issn);
	setTabOrder(isbn_issn, hidingplace);
	setTabOrder(hidingplace, pages);
	setTabOrder(pages, mapper);

	QWhatsThis::add(subtitle, 		i18n("The subtitle of a publication."));
	QWhatsThis::add(bibtex,   		i18n("This box shows the bibtex entry for this publication (if any). " \
																		 "You can alter the entry or re-generate it with the 'Generate BibTex' " \
																		 "button under the box. This entry is included if you create a bibtex " \
																		 "file via 'Create BibTex' in the file menu and 'Include in BibTex' is " \
																		 "checked."));	
	QWhatsThis::add(translator,		i18n("Maybe the publication was translated by someone..."));		
	QWhatsThis::add(orgyear,			i18n("Sometimes a publication is a translation. The year of the original " \
																		 "publication goes here."));
	QWhatsThis::add(orgpublisher, i18n("Sometimes a publication is a translation or there is an earlier edition. " \
																	   "Here is some place to enter the publisher of the original edition."));
	QWhatsThis::add(orgtitle,			i18n("Sometimes a publication is a translation. Enter the title of the original " \
																		 "publication in this line."));
	QWhatsThis::add(isbn_issn,		i18n("Enter the ISBN number or the ISSN number of publication."));
	QWhatsThis::add(hidingplace,	i18n("Where was the book the last time you saw it?"));
	QWhatsThis::add(pages,      	i18n("The number of pages of the publication."));
//	QWhatsThis::add(include_bibtex,  i18n("This publication is included in the bibtex export if this box checked."));	
	QWhatsThis::add(generate_bibtex, i18n("Generates a new bibtex entry from the biliographical informations. " \
																				"The entry is written in the text area above for further editing."));
	QWhatsThis::add(mapper,   		i18n("This area takes the informations which are needed to create " \
																		 "the bibtex entries."));			

	if(url.command()=="new")
	  publ = new PublBase(conn);
	else
	  publ = new PublBase(url.where(), conn);
  ASSERT(publ);
	QString u("kaspa://bibliography#where publication.no="); u+=QString().setNum(publ->id());
	_url=u;
}

Bibliography::~Bibliography() {
//  debug("Bibliography::~Bibliography");
  delete publ;
}

bool Bibliography::isValid() {
	try {
	  return publ->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}

void Bibliography::reread() {
	try {
//	  debug("Bibliography::reread()");
  	setWorkingGUI();
	  publ->reset();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
  	setFields();
}

void Bibliography::setFields() {
  if(isValid()) {
		try {
			setWorkingGUI();
      emit setCaption(publ->getTitle());
  		pages->setText(publ->getPages());
	  	title->setText(publ->getTitle());
	  	translator->setText(publ->getTranslator());
		  subtitle->setText(publ->getSubtitle());
 			orgyear->setText(publ->getOrgYear());
			modified->setText(publ->getModified());
			created->setText(publ->getCreated());

		  PublisherName *rec=publ->getOrgPublisher();
	  	if(rec) {
			  orgpublisher->setText(rec->getTitle());
			  delete rec;
			}
		  orgtitle->setText(publ->getOrgTitle());
  		isbn_issn->setText(publ->getIsbnIssn());
	  	hidingplace->setText(publ->getHidingPlace());
			bibtex->setText(publ->getBibTex());
			includebibtex->setChecked(publ->getCreateBibTex());
			delete layout; layout=0L;
			delete btfields; btfields=0L;
			switch(publ->getEntryType()) {
				case BT_BOOK:
				case BT_INBOOK:
					entrytype->setText("Book");
					btfields=new Book(mapper);
					btfields->setFields(publ);
					break;
				case BT_BOOKLET:
					entrytype->setText("Booklet");		
					btfields=new Booklet(mapper);
					btfields->setFields(publ);
					break;
				case BT_ARTICLE:
				case BT_JOURNAL:	
					entrytype->setText("Journal");		
					btfields=new Journal(mapper);
					btfields->setFields(publ);			
					break;
				case BT_INCOLLECTION:	
					entrytype->setText("Collection");		
					btfields=new Collection(mapper);
					btfields->setFields(publ);			
					break;
				case BT_MANUAL:	
					entrytype->setText("Manual");		
					btfields=new Manual(mapper);
					btfields->setFields(publ);			
					break;
				case BT_MASTERTHESIS:	
				case BT_PHDTHESIS:	
					entrytype->setText("Masterthesis");		
					btfields=new Masterthesis(mapper);
					btfields->setFields(publ);			
					break;
				case BT_MISC:	
					entrytype->setText("Misc.");		
					btfields=new Misc(mapper);
					btfields->setFields(publ);			
					break;
				case BT_INPROCEEDING:	
				case BT_PROCEEDING:	
					entrytype->setText("Proceedings");		
					btfields=new Proceedings(mapper);
					btfields->setFields(publ);			
					break;
				case BT_TECHREPORT:	
					entrytype->setText("Technical Report");		
					btfields=new TechReport(mapper);
					btfields->setFields(publ);			
					break;
				case BT_UNPUBLISHED:	
					entrytype->setText("Unpublished");		
					btfields=new Unpublished(mapper);
					btfields->setFields(publ);			
					break;
				default:
					throw KaspaErr("Bibliography::setFields(): No valid type set!");
					abort();	
			}
			layout=new QBoxLayout(mapper, QBoxLayout::Down);
			layout->addWidget(btfields, 1);
			layout->activate();
			btfields->show();
		  setupGUI();
		} catch(KaspaErr& err) {
			handleWarning(err);
		}
	}
}


void Bibliography::flush() {
	setWorkingGUI();
	save();
	setupGUI();
}

void Bibliography::save(bool block) {
//  debug("Bibliography::save()");
	try {
	  if(isValid() && !isReadOnly() && !isWorking()) {
    	if(strcmp(pages->text(), publ->getPages()))
	      publ->setPages(pages->text());
  	  if(strcmp(title->text(), publ->getTitle()))
    	  publ->setTitle(title->text());
	    if(strcmp(translator->text(), publ->getTranslator()))
  	    publ->setTranslator(translator->text());
    	if(strcmp(subtitle->text(), publ->getSubtitle()))
	      publ->setSubtitle(subtitle->text());
  	  if(strcmp(orgyear->text(), publ->getOrgYear()))
    	  publ->setOrgYear(orgyear->text());
	    if(strcmp(orgtitle->text(), publ->getOrgTitle()))
  	    publ->setOrgTitle(orgtitle->text());
    	if(strcmp(isbn_issn->text(), publ->getIsbnIssn()))
	      publ->setIsbnIssn(isbn_issn->text());
  	  if(strcmp(hidingplace->text(), publ->getHidingPlace()))
    	  publ->setHidingPlace(hidingplace->text());
	    if(strcmp(bibtex->text(), publ->getBibTex()))
  	    publ->setBibTex(bibtex->text());
      if(includebibtex->isChecked()!= publ->getCreateBibTex())
 	      publ->setCreateBibTex(includebibtex->isChecked());

    	if(btfields) btfields->save(publ);
	    publ->flush(block);
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Bibliography::setInvalidGUI() {
//  debug("Bibliography::setInvalidGUI()");
  Inherited::setInvalidGUI();
  lockGUI();
	for(unsigned int i=0; i<sizeof(bibliocs)/sizeof(CommandSetup); i++)
		emit enableCommand(bibliocs[i].command, ((bibliocs[i].setup&INV)==INV));
  if(btfields) btfields->setInvalidGUI();
}	

void Bibliography::setReadWriteGUI() {
//  debug("Bibliography::setReadWriteGUI()");
  Inherited::setReadWriteGUI();
  unlockGUI();
	for(unsigned int i=0; i<sizeof(bibliocs)/sizeof(CommandSetup); i++)
		emit enableCommand(bibliocs[i].command, ((bibliocs[i].setup&RW)==RW));
  if(btfields) btfields->setReadWriteGUI();
}

void Bibliography::setReadOnlyGUI() {
//  debug("Bibliography::setReadOnlyGUI()");	
  Inherited::setReadOnlyGUI();
  lockGUI();
	for(unsigned int i=0; i<sizeof(bibliocs)/sizeof(CommandSetup); i++)
		emit enableCommand(bibliocs[i].command, ((bibliocs[i].setup&RO)==RO));
  if(btfields) btfields->setReadOnlyGUI();
}

void Bibliography::setWorkingGUI() {
//  debug("Bibliography::setWorkingGUI()");
	if(isReadOnly() || !isValid()) {
		lockGUI();
	  if(btfields) btfields->setWorkingGUI(true);
	}
	else {
		unlockGUI();	
	  if(btfields) btfields->setWorkingGUI(false);
	}
  Inherited::setWorkingGUI();
	for(unsigned int i=0; i<sizeof(bibliocs)/sizeof(CommandSetup); i++)
		emit enableCommand(bibliocs[i].command, ((bibliocs[i].setup&WORK)==WORK));
}


void Bibliography::del() {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()&&deleteDlg()) {
	    setWorkingGUI();
  	  publ->deleteRec();
    	setInvalidGUI();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

bool Bibliography::closeRequest() {
//  setWorkingGUI();
  save(true);	
	setupGUI();
  return true;
}

KToolBar *Bibliography::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());

  toolbar->insertButton(BarIcon("showpubl.png"), ID_BIBLIO_SHOWPUBL, SIGNAL(clicked()),
				this, SLOT(showPubl()), true, i18n("Show Publication") );
  toolbar->insertButton(BarIcon("showpublisher.png"), ID_BIBLIO_SHOWORGPUBLISHER, SIGNAL(clicked()),
				this, SLOT(showOrgPublisher()), true, i18n("Show Publisher") );

  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("inspublisher.png"), ID_BIBLIO_INSORGPUBLISHER, SIGNAL(clicked()),
				this, SLOT(insertOrgPublisher()), true, i18n("Insert Publisher") );
  toolbar->insertButton(BarIcon("newpublisher.png"), ID_BIBLIO_NEWORGPUBLISHER, SIGNAL(clicked()),
				this, SLOT(newOrgPublisher()), true, i18n("New Publisher") );

  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("filedel.png"), ID_BIBLIO_DELREC, SIGNAL(clicked()),
				this, SLOT(del()), true, i18n("Delete Record") );
  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("filefloppy.png"), ID_BIBLIO_FLUSH, SIGNAL(clicked()),
				this, SLOT(flush()), true, i18n("Save Changes") );
  toolbar->insertButton(BarIcon("reload.png"), ID_BIBLIO_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );


	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
  return toolbar;
}

void Bibliography::insertOrgPublisher() {
	try {
		SelectionDlg dlg(publ->getPublishers(), this);
		if(dlg.exec()) {
				Oid o=dlg.getOid();
				if(o==InvalidOid) return;
		    setWorkingGUI();
				publ->setOrgPublisher(o);
				save();
				setFields();			
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		
	

void Bibliography::newOrgPublisher() {
	try {
    setWorkingGUI();
		Oid o=publ->createPublisher();
		publ->setOrgPublisher(o);
		save();
		setupGUI();
		requestPublisher(o);
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Bibliography::showOrgPublisher() {
	try {
    setWorkingGUI();
		PublisherName *p=publ->getOrgPublisher();
		if(p) {
			save();
			requestPublisher(p->getOid());
		}
		else
			KMessageBox::information(this, "No Publisher defined!", "Information");
		setupGUI();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void Bibliography::showPubl() {
	save(true);
	QString s("kaspa://publication#");
	s+=_url.where();
	requestURL(s, false);
	setupGUI();
}

void Bibliography::generateBibTex() {
  AuthorName *a=0L;
  try {
  	if(!bibtex->text().isEmpty()&&
       (KMessageBox::questionYesNo(this, "Overwrite old entry?", "Generate BibTex")==KMessageBox::No)) return;

  	save(true);

  	QString publisher;
	  QString address;
    if(publ->getEntryType()==BT_ARTICLE) {
  	  JournalName *jn=publ->getJournal();
    	if(jn) {
    		publisher=jn->getTitle();
			  address=jn->getAddress();
		  	delete jn;
	  	}
  	} else {
		  PublisherName *pn=publ->getPublisher();
	  	if(pn) {
  			publisher=pn->getTitle();
			  address=pn->getAddress();
		  	delete pn;
	  	}
  	}

  	a=publ->getPublAuthors();

	  QString entry;
    int publindex=0;
    QString author;
    AuthorName *b=0L;
    AuthorName *c=0L;
	  for(b=a; b; b=b->getNext()) {
		  author=b->getFirstName()+author;
  		author=", "+author;
	  	author=b->getLastName()+author;
		  if(b->getNext())
  			author=" and "+author;
      c=b;
  	}

    if(c)	{
		  entry=c->getLastName();
		  publindex=publ->bibTexIndex(c->getOid(), publ->id());
	  }
  	else entry="NoName"+QString().setNum(publ->id());
	  entry+=publ->getYear();
  	if(publindex>0 && publindex <27)
	  	entry+=('a'+publindex-1);

  	QString note;

  	switch(publ->getEntryType()) {
		  case BT_ARTICLE:
	  			bt.article(entry,
  								author,
								  publ->getTitle(),
							  	publisher,
						  		publ->getYear(),
					  			publ->getVolume(),
				  				publ->getNumber(),
			  					publ->getPages(),
		  						publ->getMonth(),
	  							note);
  		break;

		  case BT_BOOK:
	  		bt.book(entry,
  					 author,
					   publ->getEditor(),
				  	 publ->getTitle(),
			  		 publisher,
		  			 publ->getYear(),
	  				 publ->getVolume(),
  					 publ->getNumber(),
					   publ->getSeries(),
				  	 address,
			  		 QString().setNum(publ->getEdition()),
		  			 publ->getMonth(),
	  				 note);
  		break;

	  	case BT_BOOKLET:
  	      bt.booklet(entry,
							  		 publ->getTitle(),
						  			 author,
					  				 publ->getHowPublished(),
				  					 address,
			  						 publ->getMonth(),
		  							 publ->getYear(),
	  								 note);
  		break;

	  	case BT_MANUAL:
  		  		bt.manual(entry,
								  	publ->getTitle(),
							  		author,
						  			publ->getOrganization(),
					  				address,
				  					QString().setNum(publ->getEdition()),
			  						publ->getMonth(),
		  							publ->getYear(),
	  								note);
  		break;

  	  case BT_MASTERTHESIS:
    			bt.masterthesis(entry,
								  				author,
							  				  publ->getTitle(),
						  						publ->getOrganization(),
					  							publ->getYear(),
				  								publ->getType(),
			  									address,
		  										publ->getMonth(),
	  											note);
  		break;

	    case BT_PHDTHESIS:
  				bt.phdthesis(entry,
								  		 author,
							  		   publ->getTitle(),
						  				 publ->getOrganization(),
					  					 publ->getYear(),
				  						 publ->getType(),
			  							 address,
		  								 publ->getMonth(),
	  									 note);
  		break;

	  	case BT_MISC:
  				bt.misc(entry,
					  			author,
				  			  publ->getTitle(),
			  					publ->getHowPublished(),
		  						publ->getMonth(),
	  							publ->getYear(),
  								note);
	  	break;

  		case BT_PROCEEDING:
  				bt.proceedings(entry,
											   publ->getTitle(),
										  	 publ->getYear(),
									  		 publ->getEditor(),
								  			 publ->getVolume(),
							  				 publ->getNumber(),
						  					 publ->getSeries(),
					  						 address,
				  							 publ->getMonth(),
			  								 publ->getOrganization(),
		  									 publisher,
	  										 note);
  		break;

	  	case BT_TECHREPORT:
  				bt.techreport(entry,
									  		author,
								  		  publ->getTitle(),
							  				publ->getOrganization(),
						  					publ->getYear(),
					  						address,
				  							publ->getType(),
			  								publ->getNumber(),
		  									publ->getMonth(),
	  										note);
  		break;

	  	case BT_UNPUBLISHED:
  				bt.unpublished(entry,
					  						 author,
				  						   publ->getTitle(),
			  								 note,
		  									 publ->getMonth(),
	  										 publ->getYear());
  		break;

  /* Crossref-Entrys for Part-BibTex-generation */
		  case BT_JOURNAL:
	  			bt.article("Ref"+QString().setNum(publ->id()),
  								"", 							/* author */
								  "",								/* title */
							  	publ->getTitle(), 				/* journal */
						  		publ->getYear(),
					  			publ->getVolume(),
				  				publ->getNumber(),
			  					"",								/* pages */
		  						publ->getMonth(),
	  							note);
  		break;

	  	case BT_INBOOK:
  				bt.inbook("Ref"+QString().setNum(publ->id()),
					  				"",										/* author */
				  					author,								/* editor */
			  						publ->getTitle(),
		  							"",										/* chapterno */
	  								"",										/* pages */
  									publisher,
									  publ->getYear(),
								  	publ->getVolume(),
							  		"",										/* number */
						  			publ->getSeries(),
					  				publ->getType(),
				  					address,
			  						QString().setNum(publ->getEdition()),
		  							publ->getMonth(),
	  								note);
  			break;

	  		case BT_INCOLLECTION:
  				bt.incollection("Ref"+QString().setNum(publ->id()),
					  							"",								/* author */
				  								"",								/* title */
			  									publ->getTitle(), /* booktitle */
		  										publisher,
	  											publ->getYear(),
  												author,						/* editor */
												  publ->getVolume(),
											  	"",								/* number */
										  		publ->getSeries(),
									  			publ->getType(),
								  				"",								/* chapterno */
							  					"",								/* pages */
						  						address,
			  									QString().setNum(publ->getEdition()),
		 		  								publ->getMonth(),
	 				  							note);
  			break;

		  	case BT_INPROCEEDING:
	  				 bt.inproceedings("Ref"+QString().setNum(publ->id()),
  														"",									/* author */
														  "", 									/* title */
													  	publ->getTitle(),		/* booktitle */
												  		publ->getYear(),
											  			author,							/* editor */
										  				publ->getVolume(),
									  					"",									/* number */
								  						publ->getSeries(),
							  							"",									/* pages */
						  								address,
					  									publ->getMonth(),
  			  										publ->getOrganization(),
			  											publisher,
		  												note);

  	}
	  bibtex->setText(bt.getEntry());
  } catch(KaspaErr err) {
	  handleWarning(err);
  }
	delete a;
}
