/***************************************************************************
                          search.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: search.cpp
	Last generated: Thu Jul 20 23:16:10 2000

 *********************************************************************/

#include "search.h"
#include <qwhatsthis.h>
#include <klocale.h>

#define Inherited SearchData


Search::Search(KaspaURL url, Sql *conn, QWidget* parent = 0L, const char* name = 0L):
	Inherited(parent, name) {
	_url=url;
	setTabOrder(search, start);
	setTabOrder(start, fulltext);
	setTabOrder(fulltext, exact);
	setTabOrder(exact, result);	
	QWhatsThis::add(search,		i18n("A input line to type in your query. The search matches substrings " \
																 "unless 'exact search' is checked."));
	QWhatsThis::add(start, 		i18n("Press this button to delete your database."));	
	QWhatsThis::add(fulltext,	i18n("Check this box to extend your search on the fulltext index."));
	QWhatsThis::add(result,		i18n("The results of the search double-click the entrys to open them " \
																 "or click with the right mouse button to open the context menu."));		
	QWhatsThis::add(exact,		i18n("Check this to match exactly the search string."));

  connect(result,   SIGNAL(open(Oid, const char *, bool)), this, SLOT(open(Oid, const char *, bool)));
	connect(search, SIGNAL(returnPressed()), this, SLOT(startSearch()));
	try {
		base=new MyKaspaBase(conn);
		ASSERT(base);
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

Search::~Search() { delete base; }

void Search::startSearch() {
	try {
		if(!strlen(search->text())) return;
		setWorkingGUI();

		QString w;
		if(exact->isChecked()) w=" = '";
		else w=" ~* '";
		w+=esc4sql(search->text()); w+="'";

		QString s("where part.title"); s+=w+" or part.memo"+w+" or part.language"+w;
		result->set(base->getPartTitles(s, true));
		s="where publication.title"+w+" or publication.memo"+w+" or publication.subtitle"+w+
      " or publication.editor"+w+" or publication.howpublished"+w+
      " or publication.hidingplace"+w+" or publication.organization"+w;
		result->append(base->getPublTitles(s));
		s="where note.title"+w+" or note.memo"+w;
		result->append(base->getNoteTitles(s));
		s="where author.lastname"+w+" or author.memo"+w+" or author.firstname"+w+
      " or author.pseudonym"+w+" or author.country"+w;
		result->append(base->getAuthorNames(s));
		s="where publisher.name"+w;
		result->append(base->getPublisherNames(s));

		if(fulltext->isChecked()) {
      s="where partdata.astext"+w;
      result->append(base->getPartDataNames(s, true));
		}	

		setupGUI();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void Search::open(Oid o, const char *data, bool w) {
	if(!strcmp(data, "note")) requestNote(o, w);
	if(!strcmp(data, "publication")) requestPublication(o, w);
	if(!strcmp(data, "part")) requestPart(o, w);
	if(!strcmp(data, "partmemo")) requestPartMemo(o, w);
	if(!strcmp(data, "author")) requestAuthor(o, w);
	if(!strcmp(data, "publisher")) requestPublisher(o, w);
	if(!strcmp(data, "bibliography")) requestBibliography(o, w);
	if(!strcmp(data, "partdata")) requestHTMLData(o, w);
}






